/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.RemoteInstructionViewer;
import cc.squirreljme.jdwp.JDWPId;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.multiphasicapps.classfile.Pool;

public class InfoByteCode
extends Info {
    protected final WeakReference<InfoMethod> method;
    protected final KnownValue<Pool> constantPool;
    private final byte[] _byteCode;
    private volatile InstructionViewer[] _instructions;

    public InfoByteCode(DebuggerState __state, JDWPId __id, InfoMethod __method, KnownValue<Pool> __constantPool, byte[] __byteCode) throws NullPointerException {
        super(__state, __id, InfoKind.BYTE_CODE);
        this.method = new WeakReference<InfoMethod>(__method);
        this.constantPool = __constantPool;
        this._byteCode = (byte[])__byteCode.clone();
    }

    public InstructionViewer[] instructions() {
        RemoteInstructionViewer instruction;
        InstructionViewer[] result = this._instructions;
        if (result != null) {
            return (InstructionViewer[])result.clone();
        }
        ArrayList<RemoteInstructionViewer> output = new ArrayList<RemoteInstructionViewer>();
        KnownValue<Pool> pool = this.constantPool;
        byte[] byteCode = this._byteCode;
        int limit = byteCode.length;
        for (int at2 = 0; at2 < limit; at2 += instruction.length()) {
            instruction = new RemoteInstructionViewer(this.internalState(), pool, byteCode, at2);
            output.add(instruction);
        }
        this._instructions = result = output.toArray(new InstructionViewer[output.size()]);
        return (InstructionViewer[])result.clone();
    }

    @Override
    protected boolean internalUpdate(DebuggerState __state) throws NullPointerException {
        return true;
    }
}

