/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.KnownValueCallback;
import cc.squirreljme.debugger.ReplyHandler;
import cc.squirreljme.jdwp.JDWPCapability;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPCommandSetReferenceType;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.jdwp.JDWPPacket;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Objects;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodFlags;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.Pool;
import org.jetbrains.annotations.NotNull;

public class InfoClass
extends Info {
    protected final KnownValue<ClassName> thisName = new KnownValue<ClassName>(ClassName.class, this::__updateThisName);
    protected final KnownValue<Pool> constantPool = new KnownValue<Pool>(Pool.class, this::__updateConstantPool);
    protected final KnownValue<InfoMethod[]> methods = new KnownValue<InfoMethod[]>(InfoMethod[].class, this::__updateMethods);

    public InfoClass(DebuggerState __state, JDWPId __id) throws NullPointerException {
        super(__state, __id, InfoKind.CLASS);
    }

    @Override
    public int compareTo(@NotNull Info __o) {
        String b2;
        if (__o == this || !(__o instanceof InfoClass)) {
            return super.compareTo(__o);
        }
        String a2 = Objects.toString(this.thisName.getOrDefault(null), "a");
        int rv = a2.compareTo(b2 = Objects.toString(((InfoClass)__o).thisName.getOrDefault(null), "b"));
        if (rv != 0) {
            return rv;
        }
        return super.compareTo(__o);
    }

    public InfoMethod getMethod(JDWPId __methodId) {
        InfoMethod[] methods = this.methods.getOrUpdateSync(this.internalState());
        if (methods == null || methods.length == 0) {
            return null;
        }
        for (InfoMethod method : methods) {
            if (method.id.id != __methodId.id) continue;
            return method;
        }
        return null;
    }

    @Override
    protected String internalString() {
        ClassName result = this.thisName.get();
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    @Override
    protected boolean internalUpdate(DebuggerState __state) throws NullPointerException {
        return true;
    }

    public InfoMethod[] methods() {
        return this.methods.getOrUpdateSync(this.internalState());
    }

    public ClassName thisName() {
        return this.thisName.getOrUpdateSync(this.internalState());
    }

    private void __updateConstantPool(DebuggerState __state, KnownValue<Pool> __value, KnownValueCallback<Pool> __sync) {
        if (__value.isKnown()) {
            if (__sync != null) {
                __sync.sync(__state, __value);
            }
            return;
        }
        if (!__state.capabilities.has(JDWPCapability.CAN_GET_CONSTANT_POOL)) {
            __value.set(null);
            return;
        }
        try (JDWPPacket out = __state.request(JDWPCommandSet.REFERENCE_TYPE, JDWPCommandSetReferenceType.CONSTANT_POOL);){
            out.writeId(this.id);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> {
                int count = __reply.readInt();
                int length = __reply.readInt();
                byte[] data = __reply.readFully(length);
                try (ByteArrayInputStream in = new ByteArrayInputStream(data);
                     DataInputStream din = new DataInputStream(in);){
                    __value.set(Pool.decode(din, count));
                }
                catch (IOException __e) {
                    __e.printStackTrace();
                }
            }, ReplyHandler.IGNORED);
        }
    }

    private void __updateMethods(DebuggerState __state, KnownValue<InfoMethod[]> __value, KnownValueCallback<InfoMethod[]> __sync) throws NullPointerException {
        if (__state == null || __value == null) {
            throw new NullPointerException("NARG");
        }
        if (__value.isKnown()) {
            if (__sync != null) {
                __sync.sync(__state, __value);
            }
            return;
        }
        try (JDWPPacket out = __state.request(JDWPCommandSet.REFERENCE_TYPE, JDWPCommandSetReferenceType.METHODS);){
            out.writeId(this.id);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> {
                int count = __reply.readInt();
                InfoMethod[] result = new InfoMethod[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    InfoMethod method;
                    JDWPId methodId = __reply.readId(JDWPIdKind.METHOD_ID);
                    MethodName name = new MethodName(__reply.readString());
                    MethodDescriptor type = new MethodDescriptor(__reply.readString());
                    MethodFlags flags = new MethodFlags(__reply.readInt() & 0xFFFFFFF);
                    result[i2] = method = new InfoMethod(__state, methodId, this, name, type, flags);
                    method.name.set(name);
                    method.type.set(type);
                    method.flags.set(flags);
                }
                __value.set(result);
            }, ReplyHandler.IGNORED);
        }
    }

    private void __updateThisName(DebuggerState __state, KnownValue<ClassName> __value, KnownValueCallback<ClassName> __sync) throws NullPointerException {
        if (__state == null || __value == null) {
            throw new NullPointerException("NARG");
        }
        if (__value.isKnown()) {
            if (__sync != null) {
                __sync.sync(__state, __value);
            }
            return;
        }
        try (JDWPPacket out = __state.request(JDWPCommandSet.REFERENCE_TYPE, JDWPCommandSetReferenceType.SIGNATURE);){
            out.writeId(this.id);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> {
                String value = __reply.readString();
                __value.set(new FieldDescriptor(value).className());
            }, ReplyHandler.IGNORED);
        }
    }
}

