/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoFrameLocals;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.KnownValueCallback;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPCommandSetStackFrame;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPValueTag;

public class InfoFrame
extends Info {
    private static final JDWPValueTag[] _TAGS = JDWPValueTag.values();
    protected final InfoThread inThread;
    protected final FrameLocation location;
    protected final KnownValue<InfoFrameLocals> variables;

    public InfoFrame(DebuggerState __state, JDWPId __id, InfoThread __thread, FrameLocation __location) throws NullPointerException {
        super(__state, __id, InfoKind.FRAME);
        if (__thread == null || __location == null) {
            throw new NullPointerException("NARG");
        }
        this.inThread = __thread;
        this.location = __location;
        this.variables = new KnownValue<InfoFrameLocals>(InfoFrameLocals.class, this::__updateVariables);
    }

    public InfoMethod inMethod() {
        return this.location.inMethod;
    }

    @Override
    protected boolean internalUpdate(DebuggerState __state) throws NullPointerException {
        return true;
    }

    @Override
    protected String internalString() {
        DebuggerState state = this.internalState();
        InfoMethod inMethod = this.location.inMethod;
        return String.format("%s:%s @ %d", inMethod == null ? "<opaque>" : inMethod.name.getOrUpdateSync(state), inMethod == null ? "<opaque>" : inMethod.type.getOrUpdateSync(state), this.location.index);
    }

    private void __updateChain(DebuggerState __state, JDWPId __inThread, JDWPId __inFrame, KnownValue<InfoFrameLocals> __value, InfoFrameLocals __locals, int __varIndex, int __tagType, int __varLimit, KnownValueCallback<InfoFrameLocals> __sync) {
        JDWPValueTag[] tags = _TAGS;
        if (__tagType >= tags.length) {
            return;
        }
        JDWPValueTag tag = tags[__tagType];
        try (JDWPPacket out = __state.request(JDWPCommandSet.STACK_FRAMES, JDWPCommandSetStackFrame.GET_VALUES);){
            out.writeId(__inThread);
            out.writeId(__inFrame);
            out.writeInt(1);
            out.writeInt(__varIndex);
            out.writeByte(tag.tag);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> {
                int numValues = __reply.readInt();
                if (numValues > 0) {
                    __locals.set(__varIndex, __reply.readValue());
                }
                if (__varIndex < 126) {
                    this.__updateChain(__state, __inThread, __inFrame, __value, __locals, __varIndex + 1, 0, Math.min(127, __varIndex + 8), __sync);
                }
            }, (__ignored, __reply) -> {
                if (__reply.hasError(JDWPErrorType.INVALID_SLOT)) {
                    if (__varIndex < __varLimit) {
                        this.__updateChain(__state, __inThread, __inFrame, __value, __locals, __varIndex + 1, 0, __varLimit, __sync);
                    }
                    return;
                }
                this.__updateChain(__state, __inThread, __inFrame, __value, __locals, __varIndex, __tagType + 1, __varLimit, __sync);
            });
        }
    }

    private void __updateVariables(DebuggerState __state, KnownValue<InfoFrameLocals> __value, KnownValueCallback<InfoFrameLocals> __sync) {
        InfoFrameLocals locals = __value.get();
        if (locals == null) {
            locals = new InfoFrameLocals();
            __value.set(locals);
        }
        JDWPId inThread = this.inThread.id;
        JDWPId inFrame = this.id;
        this.__updateChain(__state, inThread, inFrame, __value, locals, 0, 0, 8, __sync);
    }
}

