/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoByteCode;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.jdwp.JDWPId;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodFlags;
import net.multiphasicapps.classfile.MethodName;

public enum InfoKind {
    FRAME("Frame", "Frames"){

        @Override
        protected Info seed(DebuggerState __state, JDWPId __id, Object ... __extra) {
            InfoThread thread = (InfoThread)__extra[0];
            FrameLocation location = (FrameLocation)__extra[1];
            return new InfoFrame(__state, __id, thread, location);
        }
    }
    ,
    THREAD("Thread", "Threads"){

        @Override
        protected Info seed(DebuggerState __state, JDWPId __id, Object ... __extra) {
            return new InfoThread(__state, __id);
        }
    }
    ,
    CLASS("Class", "Classes"){

        @Override
        protected Info seed(DebuggerState __state, JDWPId __id, Object ... __extra) {
            return new InfoClass(__state, __id);
        }
    }
    ,
    METHOD("Method", "Methods"){

        @Override
        protected Info seed(DebuggerState __state, JDWPId __id, Object ... __extra) {
            InfoClass inClass = (InfoClass)__extra[0];
            MethodName name = (MethodName)__extra[1];
            MethodDescriptor type = (MethodDescriptor)__extra[2];
            MethodFlags flags = (MethodFlags)__extra[3];
            return new InfoMethod(__state, __id, inClass, name, type, flags);
        }
    }
    ,
    BYTE_CODE("Bytecode", "Bytecode"){

        @Override
        protected Info seed(DebuggerState __state, JDWPId __id, Object ... __extra) {
            InfoMethod method = (InfoMethod)__extra[0];
            KnownValue constantPool = (KnownValue)__extra[1];
            byte[] byteCode = (byte[])__extra[2];
            return new InfoByteCode(__state, __id, method, constantPool, byteCode);
        }
    };

    public final String singular;
    public final String plural;

    private InfoKind(String __singular, String __plural) {
        this.singular = __singular;
        this.plural = __plural;
    }

    protected abstract Info seed(DebuggerState var1, JDWPId var2, Object ... var3);

    public final boolean isForgettable() {
        return false;
    }

    public String toString() {
        return this.singular;
    }
}

