/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoByteCode;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.KnownValueCallback;
import cc.squirreljme.debugger.ReplyHandler;
import cc.squirreljme.debugger.StoredInfo;
import cc.squirreljme.jdwp.JDWPCapability;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPCommandSetMethod;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPPacket;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodFlags;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.Pool;

public class InfoMethod
extends Info {
    protected final InfoClass inClass;
    protected final KnownValue<MethodFlags> flags;
    protected final KnownValue<MethodName> name;
    protected final KnownValue<MethodDescriptor> type;
    protected final KnownValue<InfoByteCode> byteCode;

    public InfoMethod(DebuggerState __state, JDWPId __id, InfoClass __inClass, MethodName __name, MethodDescriptor __type, MethodFlags __flags) throws NullPointerException {
        super(__state, __id, InfoKind.METHOD);
        if (__inClass == null) {
            throw new NullPointerException("NARG");
        }
        this.inClass = __inClass;
        this.name = new KnownValue<MethodName>(MethodName.class, __name, this::__updateGeneric);
        this.type = new KnownValue<MethodDescriptor>(MethodDescriptor.class, __type, this::__updateGeneric);
        this.flags = new KnownValue<MethodFlags>(MethodFlags.class, __flags, this::__updateGeneric);
        this.byteCode = new KnownValue<InfoByteCode>(InfoByteCode.class, this::__updateByteCode);
    }

    @Override
    protected boolean internalUpdate(DebuggerState __state) throws NullPointerException {
        return true;
    }

    @Override
    protected String internalString() {
        DebuggerState state = this.internalState();
        MethodName name = this.name.getOrUpdateSync(state);
        MethodDescriptor type = this.type.getOrUpdateSync(state);
        return String.format("%s:%s", name, type);
    }

    private void __updateByteCode(DebuggerState __state, KnownValue<InfoByteCode> __value, KnownValueCallback<InfoByteCode> __sync) throws NullPointerException {
        if (__state == null || __value == null) {
            throw new NullPointerException("NARG");
        }
        if (__value.isKnown()) {
            if (__sync != null) {
                __sync.sync(__state, __value);
            }
            return;
        }
        InfoClass inClass = this.inClass;
        MethodFlags flags = this.flags.getOrUpdateSync(__state);
        if (!__state.capabilities.has(JDWPCapability.CAN_GET_BYTECODES) || flags != null && (flags.isAbstract() || flags.isNative())) {
            __value.set(null);
            return;
        }
        KnownValue<Pool> constantPool = inClass.constantPool;
        try (JDWPPacket out = __state.request(JDWPCommandSet.METHODS, JDWPCommandSetMethod.BYTE_CODES);){
            out.writeId(inClass.id);
            out.writeId(this.id);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> {
                StoredInfo<InfoByteCode> stored = __state.storedInfo.getByteCodes();
                int length = __reply.readInt();
                byte[] data = new byte[length];
                __reply.readFully(data, 0, length);
                __value.set(stored.get(__state, this.id, this, constantPool, data));
            }, ReplyHandler.IGNORED);
        }
    }

    private void __updateGeneric(DebuggerState __state, KnownValue<?> __value, KnownValueCallback<?> __sync) {
        KnownValue<MethodName> name = this.name;
        KnownValue<MethodDescriptor> type = this.type;
        KnownValue<MethodFlags> flags = this.flags;
        if (name.isKnown() && type.isKnown() && flags.isKnown()) {
            return;
        }
        this.inClass.methods.update(__state, (DebuggerState __ignored1, KnownValue<T> __ignored2) -> {});
    }
}

