/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.KnownValueCallback;
import cc.squirreljme.debugger.KnownValueUpdater;
import cc.squirreljme.debugger.ReplyHandler;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPCommandSetThreadReference;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.PrintStream;
import org.jetbrains.annotations.NotNull;

public class InfoThread
extends Info {
    protected final KnownValue<Boolean> isStarted = new KnownValue<Boolean>(Boolean.class, false, KnownValueUpdater.IGNORED);
    protected final KnownValue<String> threadName;
    protected final KnownValue<Boolean> isDead = new KnownValue<Boolean>(Boolean.class, false, KnownValueUpdater.IGNORED);
    protected final KnownValue<Integer> suspendCount;
    protected final KnownValue<InfoFrame[]> frames;

    public InfoThread(DebuggerState __state, JDWPId __id) {
        super(__state, __id, InfoKind.THREAD);
        this.threadName = new KnownValue<String>(String.class, this::__updateThreadName);
        this.suspendCount = new KnownValue<Integer>(Integer.class, this::__updateSuspendCount);
        this.frames = new KnownValue<InfoFrame[]>(InfoFrame[].class, this::__updateFrames);
    }

    @Override
    public int compareTo(@NotNull Info __o) {
        int rv;
        boolean bDead;
        if (__o == this || !(__o instanceof InfoThread)) {
            return super.compareTo(__o);
        }
        InfoThread other = (InfoThread)__o;
        boolean aDead = this.isDead.getOrDefault(false);
        if (aDead != (bDead = other.isDead.getOrDefault(false).booleanValue())) {
            return aDead ? 1 : -1;
        }
        String aName = this.threadName.getOrDefault(null);
        String bName = this.threadName.getOrDefault(null);
        if (aName != null && bName != null && (rv = aName.compareTo(bName)) != 0) {
            return rv;
        }
        return super.compareTo(__o);
    }

    @Override
    protected String internalString() {
        String name = this.threadName.getOrUpdateSync(this.internalState());
        String result = String.format("%s (%d)", name != null ? name : "Unknown?", this.id.id);
        if (this.isDead.getOrDefault(false).booleanValue()) {
            return "DEAD " + result;
        }
        return result;
    }

    @Override
    public boolean internalUpdate(DebuggerState __state) throws NullPointerException {
        return true;
    }

    public void printStackTrace(DebuggerState __state, PrintStream __ps) throws NullPointerException {
        if (__state == null || __ps == null) {
            throw new NullPointerException("NARG");
        }
        Debugging.todoNote("Implement debugger printStackTrace().");
    }

    private void __updateFrames(DebuggerState __state, KnownValue<InfoFrame[]> __value, KnownValueCallback<InfoFrame[]> __sync) {
        try (JDWPPacket out = __state.request(JDWPCommandSet.THREAD_REFERENCE, JDWPCommandSetThreadReference.FRAMES);){
            out.writeId(this.id);
            out.writeInt(0);
            out.writeInt(-1);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> {
                int numFrames = __reply.readInt();
                InfoFrame[] result = new InfoFrame[numFrames];
                for (int i2 = 0; i2 < numFrames; ++i2) {
                    JDWPId frameId = __reply.readId(JDWPIdKind.FRAME_ID);
                    FrameLocation location = __state.readLocation(this, __reply);
                    result[i2] = new InfoFrame(__state, frameId, this, location);
                }
                __value.set(result);
            }, ReplyHandler.IGNORED);
        }
    }

    private void __updateSuspendCount(DebuggerState __state, KnownValue<Integer> __value, KnownValueCallback<Integer> __sync) {
        try (JDWPPacket out = __state.request(JDWPCommandSet.THREAD_REFERENCE, JDWPCommandSetThreadReference.SUSPEND_COUNT);){
            out.writeId(this.id);
            __state.sendKnown(out, __value, __sync, (__ignored, __reply) -> __value.set(__reply.readInt()), ReplyHandler.IGNORED);
        }
    }

    private void __updateThreadName(DebuggerState __state, KnownValue<String> __value, KnownValueCallback<String> __sync) {
        try (JDWPPacket out = __state.request(JDWPCommandSet.THREAD_REFERENCE, JDWPCommandSetThreadReference.NAME);){
            out.writeId(this.id);
            __state.sendKnown(out, __value, __sync, (__ignored, __response) -> __value.set(__response.readString()), (__ignored, __response) -> this.dispose());
        }
    }
}

