/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InspectKnownValue;
import cc.squirreljme.debugger.KeyValuePanel;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.KnownValueUpdater;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public abstract class Inspect<I extends Info>
extends JDialog {
    private final List<InspectKnownValue> _known = new ArrayList<InspectKnownValue>();
    protected final SequentialPanel panel;
    protected final DebuggerState state;
    protected final Window owner;
    private final WeakReference<I> _what;

    public Inspect(Window __owner, DebuggerState __state, I __what) throws NullPointerException {
        SequentialPanel panel;
        if (__owner == null || __state == null || __what == null) {
            throw new NullPointerException("NARG");
        }
        this.owner = __owner;
        this._what = new WeakReference<I>(__what);
        this.setTitle(((Info)__what).toString());
        Utils.setIcon(this);
        this.state = __state;
        this.setMinimumSize(new Dimension(320, 240));
        this.setLayout(new BorderLayout());
        this.panel = panel = new SequentialPanel(true);
        this.add((Component)panel.panel(), "Center");
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(this::__refreshButton);
        panel.add(refresh);
        panel.add(new KeyValuePanel(new JLabel("Key"), new JLabel("Value")));
    }

    protected abstract void updateInternal();

    protected final void addTrack(String __desc, KnownValue<?> __value) throws NullPointerException {
        if (__desc == null || __value == null) {
            throw new NullPointerException("NARG");
        }
        JLabel key = new JLabel(__desc);
        key.setMinimumSize(new Dimension(100, 1));
        InspectKnownValue value = new InspectKnownValue(this.owner, this.state, __value);
        this.panel.add(new KeyValuePanel(key, value));
        this._known.add(value);
        this.pack();
    }

    protected final void addTrack(String __desc, Object __value) throws NullPointerException {
        if (__desc == null || __value == null) {
            throw new NullPointerException("NARG");
        }
        if (__value instanceof KnownValue) {
            this.addTrack(__desc, (KnownValue)__value);
        } else {
            this.addTrack(__desc, new KnownValue(__value.getClass(), KnownValueUpdater.IGNORED));
        }
    }

    public final void update() {
        I what = this.what();
        if (what != null) {
            ((Info)what).update(this.state, this::__update);
        }
    }

    protected final I what() {
        return (I)((Info)this._what.get());
    }

    private void __refreshButton(ActionEvent __event) {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __update(Info __info) {
        this.updateInternal();
        I what = this.what();
        if (what == null) {
            this.setTitle("Garbage Collected");
        } else {
            this.setTitle(((Info)what).toString());
        }
        InspectKnownValue[] inspectKnownValueArray = this;
        synchronized (this) {
            List<InspectKnownValue> known = this._known;
            InspectKnownValue[] update = known.toArray(new InspectKnownValue[known.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (InspectKnownValue known2 : update) {
                known2.update();
            }
            this.pack();
            return;
        }
    }
}

