/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoByteCode;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.RemoteMethodViewer;
import cc.squirreljme.debugger.ShownMethodDialog;
import cc.squirreljme.debugger.Utils;
import java.awt.FlowLayout;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class InspectKnownValue
extends JPanel {
    protected final BiFunction<JComponent, KnownValue<?>, JComponent> updater;
    protected final JComponent base;
    protected final Window owner;
    protected final DebuggerState state;
    private final Reference<KnownValue<?>> _value;

    public InspectKnownValue(Window __owner, DebuggerState __state, KnownValue<?> __value) throws NullPointerException {
        if (__state == null || __value == null) {
            throw new NullPointerException("NARG");
        }
        this.owner = __owner;
        this.state = __state;
        this._value = new WeakReference(__value);
        BiFunction<JComponent, KnownValue, JComponent> updater = __value.type == Boolean.class ? this::__updateBoolean : (__value.type == InfoByteCode.class ? this::__updateByteCode : (__value.type == InfoMethod[].class ? this::__updateMethods : (__value.type == String.class ? this::__updateString : (Number.class.isAssignableFrom(__value.type) ? this::__updateNumber : this::__updateUnknown))));
        JComponent base = updater.apply(null, __value);
        FlowLayout layout = new FlowLayout(3);
        layout.setVgap(0);
        layout.setHgap(0);
        layout.setAlignment(3);
        this.setLayout(layout);
        this.add(base);
        this.base = base;
        this.updater = updater;
    }

    public void update() {
        KnownValue<?> value = this.__value();
        if (value != null) {
            this.updater.apply(this.base, value);
        }
    }

    private JComponent __updateBoolean(JComponent __base, KnownValue<?> __value) {
        JCheckBox check;
        if (__base != null) {
            check = (JCheckBox)__base;
        } else {
            check = new JCheckBox();
            check.setEnabled(false);
        }
        if (!__value.isKnown()) {
            check.setText("Unknown?");
        } else {
            check.setSelected((Boolean)__value.get());
            check.setText("");
        }
        return check;
    }

    private JComponent __updateByteCode(JComponent __base, KnownValue<?> __value) {
        JButton button;
        if (__base != null) {
            button = (JButton)__base;
        } else {
            button = new JButton();
            button.addActionListener(__event -> {
                InfoByteCode byteCode = __value.get(InfoByteCode.class);
                if (byteCode == null) {
                    return;
                }
                InfoMethod infoMethod = (InfoMethod)byteCode.method.get();
                if (infoMethod == null) {
                    return;
                }
                ShownMethodDialog dialog = new ShownMethodDialog(this.owner, this.state, new RemoteMethodViewer(this.state, infoMethod));
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            });
        }
        if (!__value.isKnown()) {
            button.setText("Unknown?");
        } else {
            button.setText("Show Bytecode");
        }
        return button;
    }

    private JComponent __updateMethods(JComponent __base, KnownValue<?> __value) {
        JButton button;
        if (__base != null) {
            button = (JButton)__base;
        } else {
            button = new JButton();
            button.addActionListener(__event -> {
                Info[] methods = __value.get(InfoMethod[].class);
                if (methods == null) {
                    return;
                }
                DebuggerState state = this.state;
                for (InfoMethod infoMethod : methods) {
                    infoMethod.update(state, null);
                }
                Utils.inspect(this.owner, state, InfoKind.METHOD, methods);
            });
        }
        if (!__value.isKnown()) {
            button.setText("Unknown?");
        } else {
            InfoMethod[] methods = __value.get(InfoMethod[].class);
            button.setText(String.format("%d Methods", methods.length));
        }
        return button;
    }

    private JComponent __updateNumber(JComponent __base, KnownValue<?> __value) {
        JTextField text;
        if (__base != null) {
            text = (JTextField)__base;
        } else {
            text = new JTextField();
            text.setEditable(false);
            text.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        if (!__value.isKnown()) {
            text.setText("Unknown?");
        } else {
            text.setText(Long.toString(((Number)__value.get()).longValue(), 10));
        }
        return text;
    }

    private JComponent __updateString(JComponent __base, KnownValue<?> __value) {
        JTextField text;
        if (__base != null) {
            text = (JTextField)__base;
        } else {
            text = new JTextField();
            text.setEditable(false);
            text.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        if (!__value.isKnown()) {
            text.setText("Unknown?");
        } else {
            text.setText((String)__value.get());
        }
        return text;
    }

    private JComponent __updateUnknown(JComponent __base, KnownValue<?> __value) {
        JLabel label = __base != null ? (JLabel)__base : new JLabel();
        if (!__value.isKnown()) {
            label.setText("Unknown?");
        } else {
            label.setText(Objects.toString(__value.get()));
        }
        return label;
    }

    private KnownValue<?> __value() {
        return this._value.get();
    }
}

