/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.JavaInstructionViewer;
import cc.squirreljme.debugger.MethodViewer;
import net.multiphasicapps.classfile.ByteCode;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.Method;
import net.multiphasicapps.classfile.MethodNameAndType;

public class JavaMethodViewer
implements MethodViewer {
    protected final Method method;
    private volatile InstructionViewer[] _instructions;

    public JavaMethodViewer(Method __method) throws NullPointerException {
        if (__method == null) {
            throw new NullPointerException("NARG");
        }
        this.method = __method;
    }

    @Override
    public ClassName inClass() {
        return this.method.inClass();
    }

    @Override
    public boolean isAbstract() {
        return this.method.flags().isAbstract();
    }

    @Override
    public boolean isNative() {
        return this.method.flags().isNative();
    }

    @Override
    public MethodNameAndType methodNameAndType() {
        return this.method.nameAndType();
    }

    @Override
    public InstructionViewer[] instructions() {
        if (this.isAbstract() || this.isNative()) {
            return null;
        }
        InstructionViewer[] result = this._instructions;
        if (result != null) {
            return (InstructionViewer[])result.clone();
        }
        ByteCode byteCode = this.method.byteCode();
        int count = byteCode.instructionCount();
        result = new InstructionViewer[count];
        for (int i2 = 0; i2 < count; ++i2) {
            result[i2] = new JavaInstructionViewer(byteCode.getByIndex(i2));
        }
        this._instructions = result;
        return (InstructionViewer[])result.clone();
    }
}

