/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.KnownValueCallback;
import cc.squirreljme.debugger.KnownValueUpdater;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;

public final class KnownValue<T> {
    protected final Class<T> type;
    protected final boolean isArray;
    protected final KnownValueUpdater<T> updater;
    private volatile boolean _known;
    private volatile T _value;

    public KnownValue(Class<T> __type, KnownValueUpdater<T> __updater) throws NullPointerException {
        if (__type == null || __updater == null) {
            throw new NullPointerException("NARG");
        }
        this.type = __type;
        this.isArray = __type.isArray();
        this.updater = __updater;
    }

    public KnownValue(Class<T> __type, T __value, KnownValueUpdater<T> __updater) throws NullPointerException {
        if (__type == null || __updater == null) {
            throw new NullPointerException("NARG");
        }
        this.type = __type;
        this.isArray = __type.isArray();
        this.updater = __updater;
        this._known = __value != null;
        this._value = __value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() {
        KnownValue knownValue = this;
        synchronized (knownValue) {
            this._value = null;
            this._known = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        KnownValue knownValue = this;
        synchronized (knownValue) {
            return this.__clone(this._value);
        }
    }

    public <X> X get(Class<X> __type) throws ClassCastException, NullPointerException {
        if (__type == null) {
            throw new NullPointerException("NARG");
        }
        return __type.cast(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOrDefault(T __default) {
        KnownValue knownValue = this;
        synchronized (knownValue) {
            if (this._known) {
                return this.__clone(this._value);
            }
            return __default;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getOrUpdateSync(DebuggerState __state) throws NullPointerException {
        if (__state == null) {
            throw new NullPointerException("NARG");
        }
        KnownValue knownValue = this;
        synchronized (knownValue) {
            if (this._known) {
                return this._value;
            }
        }
        ForkJoinPool pool = ForkJoinPool.commonPool();
        Future task = pool.submit(() -> this.update(__state, (__ignored1, __ignored2) -> {}));
        ((ForkJoinTask)task).join();
        KnownValue knownValue2 = this;
        synchronized (knownValue2) {
            if (this._known) {
                return this._value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown() {
        KnownValue knownValue = this;
        synchronized (knownValue) {
            return this._known;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T __v) throws ClassCastException {
        KnownValue knownValue = this;
        synchronized (knownValue) {
            this._value = this.__clone(this.type.cast(__v));
            this._known = true;
            this.notifyAll();
        }
    }

    public void update(DebuggerState __state, KnownValueCallback<T> __sync) throws NullPointerException {
        if (__state == null || __sync == null) {
            throw new NullPointerException("NARG");
        }
        KnownValueUpdater<T> updater = this.updater;
        if (updater == null) {
            __sync.sync(__state, this);
            return;
        }
        updater.update(__state, this, __sync);
    }

    private T __clone(T __value) {
        if (__value == null || !this.isArray) {
            return __value;
        }
        return (T)((Object[])__value).clone();
    }
}

