/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.debugger.PreferencesManager;
import cc.squirreljme.debugger.PrimaryFrame;
import cc.squirreljme.debugger.Utils;
import cc.squirreljme.debugger.__SavePreferencesOnExit__;
import cc.squirreljme.debugger.__SocketKill__;
import cc.squirreljme.emulator.NativeBinding;
import cc.squirreljme.jdwp.JDWPCommLink;
import cc.squirreljme.jdwp.JDWPCommLinkDirection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;

public class Main {
    public static void main(String ... __args) {
        try {
            Preferences preferences = Main.preferences();
            String connect = __args.length == 0 ? (String)JOptionPane.showInputDialog(null, "Connection address ([hostname]:port):", "Debugger Connect", 3, null, null, preferences.getLastAddress()) : __args[0];
            JDWPCommLink commLink = Main.__connect(connect);
            if (connect != null && !connect.isEmpty()) {
                preferences.setLastAddress(connect);
            }
            Main.start(commLink, preferences);
        }
        catch (Throwable __e) {
            __e.printStackTrace(System.err);
            Utils.throwableTraceDialog(null, "Failed to start debugger", __e);
            System.exit(1);
        }
    }

    @NotNull
    public static Preferences preferences() {
        Preferences preferences = new Preferences();
        PreferencesManager prefManager = new PreferencesManager();
        prefManager.load(preferences);
        return preferences;
    }

    private static JDWPCommLink __connect(String __connect) throws IOException, IllegalArgumentException, NullPointerException {
        int port;
        if (__connect == null) {
            throw new NullPointerException("NARG");
        }
        int lastCol = __connect.lastIndexOf(58);
        if (lastCol < 0) {
            throw new IOException("Invalid address: " + __connect);
        }
        try {
            port = Integer.parseInt(__connect.substring(lastCol + 1), 10);
        }
        catch (NumberFormatException __e) {
            throw new IOException("Invalid port: " + __connect, __e);
        }
        Socket socket = lastCol == 0 ? new ServerSocket(port).accept() : Main.__connectTry(__connect.substring(0, lastCol), port);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        Runtime.getRuntime().addShutdownHook(new Thread(new __SocketKill__(socket), "socketKill"));
        return new JDWPCommLink(socket.getInputStream(), socket.getOutputStream(), JDWPCommLinkDirection.DEBUGGER_TO_CLIENT);
    }

    public static void start(InputStream __in, OutputStream __out, Preferences __preferences) throws NullPointerException {
        if (__in == null || __out == null) {
            throw new NullPointerException("NARG");
        }
        Main.start(new JDWPCommLink(__in, __out, JDWPCommLinkDirection.DEBUGGER_TO_CLIENT), __preferences);
    }

    public static void start(JDWPCommLink __commLink, Preferences __preferences) throws NullPointerException {
        if (__commLink == null) {
            throw new NullPointerException("NARG");
        }
        if (__preferences == null) {
            __preferences = Main.preferences();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new __SavePreferencesOnExit__(__preferences), "PrefSave"));
        DebuggerState state = new DebuggerState(__commLink, __preferences, __state -> {});
        new Thread(state, "debugLoop").start();
        PrimaryFrame frame = new PrimaryFrame(state, __preferences);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        Utils.maximize(frame);
    }

    @NotNull
    static Socket __connectTry(String __host, int __port) throws IOException {
        ArrayList<ConnectException> fails = new ArrayList<ConnectException>();
        for (int i2 = 0; i2 < 15; ++i2) {
            try {
                return new Socket(__host, __port);
            }
            catch (ConnectException __e) {
                String msg = String.format("%s %s", __e.getMessage(), __e.getLocalizedMessage()).toLowerCase();
                if (!msg.contains("refuse")) {
                    throw __e;
                }
                fails.add(__e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException __ignored) {
                    break;
                }
            }
        }
        IOException fail = new IOException(String.format("Could not connect to %s:%d.", __host, __port));
        for (ConnectException sup : fails) {
            fail.addSuppressed(sup);
        }
        throw fail;
    }

    static {
        NativeBinding.loadedLibraryPath();
        JFrame.setDefaultLookAndFeelDecorated(true);
    }
}

