/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.BooleanConsumer;
import cc.squirreljme.debugger.KeyValuePanel;
import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Vector;
import java.util.function.BooleanSupplier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PreferencesDialog
extends JDialog {
    protected final Preferences preferences;
    protected final JList<Path> classSearchPaths;

    public PreferencesDialog(Window __owner, Preferences __preferences) throws NullPointerException {
        super(__owner);
        if (__preferences == null) {
            throw new NullPointerException("NARG");
        }
        this.preferences = __preferences;
        this.setTitle("Preferences");
        Utils.setIcon(this);
        this.setLayout(new BorderLayout());
        SequentialPanel sequence = new SequentialPanel(false);
        sequence.panel().setMinimumSize(new Dimension(400, 400));
        sequence.panel().setPreferredSize(new Dimension(400, 400));
        this.add((Component)sequence.panel(), "Center");
        JCheckBox resumeOnConnect = PreferencesDialog.__settingsCheck(__preferences::isResumeOnConnect, __preferences::setResumeOnConnect);
        sequence.add(new KeyValuePanel(new JLabel("Resume on Connect"), resumeOnConnect));
        JCheckBox localClassOnly = PreferencesDialog.__settingsCheck(__preferences::isLocalClassOnly, __preferences::setLocalClassOnly);
        sequence.add(new KeyValuePanel(new JLabel("Local Classes Only"), localClassOnly));
        JPanel classSearchPanel = new JPanel();
        classSearchPanel.setLayout(new BorderLayout());
        JList classSearchPaths = new JList();
        this.classSearchPaths = classSearchPaths;
        classSearchPaths.setMinimumSize(new Dimension(100, 200));
        classSearchPaths.setPreferredSize(new Dimension(100, 200));
        this.searchUpdate();
        JScrollPane classSearchScroll = new JScrollPane(classSearchPaths, 22, 32);
        classSearchScroll.setMinimumSize(new Dimension(100, 200));
        classSearchScroll.setPreferredSize(new Dimension(100, 200));
        JPanel classSearchButtons = new JPanel();
        classSearchButtons.setLayout(new GridLayout(1, 3));
        JButton addDirSearch = new JButton("Add Directory");
        addDirSearch.addActionListener(__event -> this.searchAdd(true));
        JButton addJarSearch = new JButton("Add Jar");
        addJarSearch.addActionListener(__event -> this.searchAdd(false));
        JButton removeSearch = new JButton("Remove");
        removeSearch.addActionListener(__event -> this.searchRemove());
        classSearchButtons.add(addDirSearch);
        classSearchButtons.add(addJarSearch);
        classSearchButtons.add(removeSearch);
        classSearchPanel.add((Component)classSearchScroll, "Center");
        classSearchPanel.add((Component)classSearchButtons, "Last");
        sequence.add(new KeyValuePanel(new JLabel("Class Search Paths"), classSearchPanel));
        JButton done = new JButton("Done");
        done.addActionListener(__event -> {
            this.setVisible(false);
            this.dispose();
        });
        this.add((Component)done, "Last");
        this.pack();
    }

    private static JCheckBox __settingsCheck(BooleanSupplier __get, BooleanConsumer __set) throws NullPointerException {
        if (__get == null || __set == null) {
            throw new NullPointerException("NARG");
        }
        JCheckBox result = new JCheckBox();
        result.setSelected(__get.getAsBoolean());
        result.addActionListener(__event -> {
            boolean set = result.isSelected();
            __set.accept(set);
            result.setSelected(set);
        });
        return result;
    }

    public void searchRemove() {
        Path selected = this.classSearchPaths.getSelectedValue();
        if (selected != null) {
            this.preferences.getClassSearchPath().remove(selected);
        }
        this.searchUpdate();
    }

    public void searchAdd(boolean __dir) {
        File file;
        JFileChooser chooser = new JFileChooser();
        if (__dir) {
            chooser.setDialogTitle("Select Directory");
            chooser.setFileSelectionMode(1);
        } else {
            chooser.setDialogTitle("Select File");
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileNameExtensionFilter("Jar Files", "zip", "jar", "kjx"));
            chooser.setAcceptAllFileFilterUsed(true);
        }
        chooser.setCurrentDirectory(Paths.get(System.getProperty("user.dir"), new String[0]).toFile());
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.preferences.getClassSearchPath().add(file.toPath().toAbsolutePath());
            this.searchUpdate();
        }
    }

    public void searchUpdate() {
        this.classSearchPaths.setListData(new Vector<Path>(this.preferences.getClassSearchPath()));
        Utils.revalidate(this.classSearchPaths);
    }
}

