/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.runtime.cldc.full.SystemPath;
import cc.squirreljme.runtime.cldc.full.SystemPathProvider;
import com.oracle.json.JsonArrayBuilder;
import com.oracle.json.JsonObject;
import com.oracle.json.JsonReader;
import com.oracle.json.JsonValue;
import com.oracle.json.JsonWriter;
import com.oracle.json.spi.JsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class PreferencesManager {
    protected final Path configPath = SystemPathProvider.provider().ofFallback(SystemPath.CONFIG).resolve("debugger.json");

    public void load(Preferences __prefs) throws NullPointerException {
        if (__prefs == null) {
            throw new NullPointerException("NARG");
        }
        JsonProvider provider = JsonProvider.provider();
        try (InputStream in = Files.newInputStream(this.configPath, StandardOpenOption.READ);
             JsonReader reader = provider.createReader(in);){
            JsonObject struct = reader.readObject();
            __prefs.setResumeOnConnect(struct.getBoolean("resumeOnConnect", true));
            __prefs.setLocalClassOnly(struct.getBoolean("localClassOnly", false));
            __prefs.setLastAddress(struct.getString("lastAddress", ":5005"));
            ArrayList<Path> paths = new ArrayList<Path>();
            for (JsonValue value : struct.getJsonArray("classSearchPath")) {
                paths.add(Paths.get(value.toString(), new String[0]));
            }
            __prefs.getClassSearchPath().clear();
            __prefs.getClassSearchPath().addAll(paths);
        }
        catch (IOException __e) {
            __e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Preferences __prefs) throws IOException, NullPointerException {
        if (__prefs == null) {
            throw new NullPointerException("NARG");
        }
        Path tempFile = null;
        JsonProvider provider = JsonProvider.provider();
        try {
            tempFile = Files.createTempFile("debugger", ".json", new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(tempFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                 JsonWriter writer = provider.createWriter(out);){
                JsonArrayBuilder searchPath = provider.createArrayBuilder();
                for (Path path : __prefs.getClassSearchPath()) {
                    searchPath.add(path.toAbsolutePath().toString());
                }
                JsonObject object = provider.createObjectBuilder().add("resumeOnConnect", __prefs.isResumeOnConnect()).add("localClassOnly", __prefs.isLocalClassOnly()).add("lastAddress", __prefs.getLastAddress()).add("classSearchPath", searchPath).build();
                writer.writeObject(object);
            }
            Path configPath = this.configPath;
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.move(tempFile, configPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

