/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.AboutDialog;
import cc.squirreljme.debugger.ClassViewer;
import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.EventModifier;
import cc.squirreljme.debugger.EventModifierClassMatch;
import cc.squirreljme.debugger.EventModifierClassOnly;
import cc.squirreljme.debugger.EventModifierLocationOnly;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.InspectCapabilities;
import cc.squirreljme.debugger.JavaClassViewer;
import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.debugger.PreferencesDialog;
import cc.squirreljme.debugger.RemoteClassViewer;
import cc.squirreljme.debugger.RemoteMethodViewer;
import cc.squirreljme.debugger.ReplyHandler;
import cc.squirreljme.debugger.ShownClassDialog;
import cc.squirreljme.debugger.ShownContextMethod;
import cc.squirreljme.debugger.ShownThreads;
import cc.squirreljme.debugger.SingleStepEvent;
import cc.squirreljme.debugger.StatusPanel;
import cc.squirreljme.debugger.StoredInfo;
import cc.squirreljme.debugger.Utils;
import cc.squirreljme.debugger.VendorCommandProbe;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPCommandSetVirtualMachine;
import cc.squirreljme.jdwp.JDWPEventKind;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPStepDepth;
import cc.squirreljme.jdwp.JDWPStepSize;
import cc.squirreljme.jdwp.JDWPSuspendPolicy;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.multiphasicapps.classfile.ClassFile;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.FieldDescriptor;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.MethodNameAndType;

public class PrimaryFrame
extends JFrame {
    protected final DebuggerState state;
    protected final StatusPanel statusPanel;
    protected final JToolBar toolBar;
    protected final ShownThreads shownThreads;
    protected final ContextThreadFrame context;
    protected final ShownContextMethod shownContext;
    protected final Preferences preferences;

    public PrimaryFrame(DebuggerState __state, Preferences __preferences) throws NullPointerException {
        StatusPanel statusPanel;
        JToolBar toolBar;
        ShownContextMethod shownContext;
        if (__state == null || __preferences == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.context = __state.context;
        this.preferences = __preferences;
        this.setMinimumSize(new Dimension(640, 480));
        this.setDefaultCloseOperation(3);
        Utils.setIcon(this);
        this.setTitle("SquirrelJME Debugger");
        int metaMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuItem preferencesItem = new JMenuItem("Preferences...");
        preferencesItem.setMnemonic('P');
        preferencesItem.setAccelerator(KeyStroke.getKeyStroke(Character.valueOf('s'), 0x200 | metaMask));
        preferencesItem.addActionListener(__event -> {
            PreferencesDialog prefs = new PreferencesDialog((Window)this, this.preferences);
            prefs.setLocationRelativeTo(null);
            prefs.setVisible(true);
        });
        JMenuItem aboutItem = new JMenuItem("About...");
        aboutItem.setMnemonic('A');
        aboutItem.setIcon(new ImageIcon(Utils.lexIcon()));
        aboutItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        aboutItem.addActionListener(__event -> {
            AboutDialog about = new AboutDialog((Window)this);
            about.setLocationRelativeTo(null);
            about.setVisible(true);
        });
        JMenuItem exitItem = PrimaryFrame.__menuItem("Exit", "system-log-out");
        exitItem.setMnemonic('x');
        exitItem.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(preferencesItem);
        fileMenu.addSeparator();
        fileMenu.add(aboutItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        JMenuItem refreshItem = PrimaryFrame.__menuItem("Refresh", "view-refresh");
        refreshItem.setMnemonic('R');
        refreshItem.addActionListener(this::__refresh);
        refreshItem.setAccelerator(KeyStroke.getKeyStroke(Character.valueOf('r'), metaMask));
        JMenuItem capsItem = new JMenuItem("Capabilities");
        capsItem.setMnemonic('C');
        capsItem.addActionListener(this::__inspectCapabilities);
        JMenuItem objectItem = new JMenuItem("Object");
        objectItem.setMnemonic('O');
        objectItem.setAccelerator(KeyStroke.getKeyStroke(Character.valueOf('o'), metaMask));
        JMenuItem typeItem = new JMenuItem("Type");
        typeItem.setMnemonic('y');
        typeItem.setAccelerator(KeyStroke.getKeyStroke(Character.valueOf('y'), metaMask));
        typeItem.addActionListener(this::__inspectType);
        JMenuItem threadGroupItem = new JMenuItem("Thread Group");
        threadGroupItem.setMnemonic('G');
        threadGroupItem.setAccelerator(KeyStroke.getKeyStroke(Character.valueOf('g'), metaMask));
        JMenuItem threadItem = new JMenuItem("Thread");
        threadItem.setMnemonic('T');
        threadItem.setAccelerator(KeyStroke.getKeyStroke(Character.valueOf('t'), metaMask));
        threadItem.addActionListener(this::__inspectThread);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        viewMenu.add(refreshItem);
        viewMenu.add(capsItem);
        viewMenu.add(objectItem);
        viewMenu.add(typeItem);
        viewMenu.add(threadGroupItem);
        viewMenu.add(threadItem);
        JMenuItem resumeSingleItem = PrimaryFrame.__menuItem("Resume Single Thread", "media-playback-start");
        resumeSingleItem.addActionListener(this::__threadSingleResume);
        resumeSingleItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        JMenuItem suspendSingleItem = PrimaryFrame.__menuItem("Suspend Single Thread", "media-playback-pause");
        suspendSingleItem.addActionListener(this::__threadSingleSuspend);
        suspendSingleItem.setAccelerator(KeyStroke.getKeyStroke(116, 64));
        JMenuItem resumeAllItem = PrimaryFrame.__menuItem("Resume All Threads", "weather-clear");
        resumeAllItem.addActionListener(this::__threadAllResume);
        resumeAllItem.setAccelerator(KeyStroke.getKeyStroke(120, 128));
        JMenuItem suspendAllItem = PrimaryFrame.__menuItem("Suspend All Threads", "weather-snow");
        suspendAllItem.addActionListener(this::__threadAllSuspend);
        suspendAllItem.setAccelerator(KeyStroke.getKeyStroke(116, 192));
        JMenuItem singleStepIntoItem = PrimaryFrame.__menuItem("Single Step Into", "go-down");
        singleStepIntoItem.addActionListener(this::__singleStepMinInto);
        singleStepIntoItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        JMenuItem singleStepOverItem = PrimaryFrame.__menuItem("Single Step Over", "go-jump");
        singleStepOverItem.addActionListener(this::__singleStepMinOver);
        singleStepOverItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        JMenuItem singleStepOutItem = PrimaryFrame.__menuItem("Single Step Out", "go-top");
        singleStepOutItem.addActionListener(this::__singleStepMinOut);
        singleStepOutItem.setAccelerator(KeyStroke.getKeyStroke(119, 64));
        JMenuItem singleLineIntoItem = PrimaryFrame.__menuItem("Single Line Step Into", "format-indent-more");
        singleLineIntoItem.addActionListener(this::__singleStepLineInto);
        singleLineIntoItem.setAccelerator(KeyStroke.getKeyStroke(118, 128));
        JMenuItem singleLineOverItem = PrimaryFrame.__menuItem("Single Line Step Over", "format-justify-center");
        singleLineOverItem.addActionListener(this::__singleStepLineOver);
        singleLineOverItem.setAccelerator(KeyStroke.getKeyStroke(119, 128));
        JMenuItem singleLineOutItem = PrimaryFrame.__menuItem("Single Line Step Out", "edit-undo");
        singleLineOutItem.addActionListener(this::__singleStepLineOut);
        singleLineOutItem.setAccelerator(KeyStroke.getKeyStroke(119, 192));
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic('D');
        debugMenu.add(resumeSingleItem);
        debugMenu.add(suspendSingleItem);
        debugMenu.addSeparator();
        debugMenu.add(resumeAllItem);
        debugMenu.add(suspendAllItem);
        debugMenu.addSeparator();
        debugMenu.add(singleStepIntoItem);
        debugMenu.add(singleStepOverItem);
        debugMenu.add(singleStepOutItem);
        debugMenu.addSeparator();
        debugMenu.add(singleLineIntoItem);
        debugMenu.add(singleLineOverItem);
        debugMenu.add(singleLineOutItem);
        JMenuItem vendorProbeItem = new JMenuItem("Probe Vendor Specific Commands");
        vendorProbeItem.setMnemonic('p');
        vendorProbeItem.addActionListener(this::__probeVendorCommands);
        JMenuItem paranoidThrows = new JMenuItem("Paranoid Throwable");
        paranoidThrows.setMnemonic('t');
        paranoidThrows.addActionListener(this::__paranoidThrows);
        JMenu advancedMenu = new JMenu("Advanced");
        advancedMenu.add(vendorProbeItem);
        advancedMenu.add(paranoidThrows);
        JMenuBar mainMenu = new JMenuBar();
        mainMenu.add(fileMenu);
        mainMenu.add(viewMenu);
        mainMenu.add(debugMenu);
        mainMenu.add(advancedMenu);
        this.setJMenuBar(mainMenu);
        ShownThreads shownThreads = new ShownThreads(__state, this.context);
        shownThreads.setMinimumSize(new Dimension(200, 300));
        shownThreads.setPreferredSize(new Dimension(200, 300));
        shownThreads.setMaximumSize(new Dimension(200, 9999));
        this.add((Component)shownThreads, "Before");
        this.shownThreads = shownThreads;
        this.shownContext = shownContext = new ShownContextMethod(this.state, this.context, __preferences);
        this.add((Component)shownContext, "Center");
        this.toolBar = toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JButton viewClassDisk = PrimaryFrame.__barButton(toolBar, "View Class From Disk", "document-open");
        viewClassDisk.addActionListener(this::__viewClassDisk);
        JButton viewClassLocal = PrimaryFrame.__barButton(toolBar, "View Class From Remote", "computer");
        viewClassLocal.addActionListener(this::__viewClassLocal);
        JButton viewClassNet = PrimaryFrame.__barButton(toolBar, "View Class From Remote", "network-receive");
        viewClassNet.addActionListener(this::__viewClassNetwork);
        toolBar.addSeparator();
        JButton refresh = PrimaryFrame.__barButton(toolBar, "Refresh", "view-refresh");
        refresh.addActionListener(this::__refresh);
        toolBar.addSeparator();
        JButton resumeSingle = PrimaryFrame.__barButton(toolBar, "Resume Single Thread", "media-playback-start");
        resumeSingle.addActionListener(this::__threadSingleResume);
        JButton suspendSingle = PrimaryFrame.__barButton(toolBar, "Suspend Single Thread", "media-playback-pause");
        suspendSingle.addActionListener(this::__threadSingleSuspend);
        toolBar.addSeparator();
        JButton resumeAll = PrimaryFrame.__barButton(toolBar, "Resume All Threads", "weather-clear");
        resumeAll.addActionListener(this::__threadAllResume);
        JButton suspendAll = PrimaryFrame.__barButton(toolBar, "Suspend All Threads", "weather-snow");
        suspendAll.addActionListener(this::__threadAllSuspend);
        toolBar.addSeparator();
        JButton singleStepInto = PrimaryFrame.__barButton(toolBar, "Single Step Into", "go-down");
        singleStepInto.addActionListener(this::__singleStepMinInto);
        JButton singleStepOver = PrimaryFrame.__barButton(toolBar, "Single Step Over", "go-jump");
        singleStepOver.addActionListener(this::__singleStepMinOver);
        JButton singleStepOut = PrimaryFrame.__barButton(toolBar, "Single Step Out", "go-top");
        singleStepOut.addActionListener(this::__singleStepMinOut);
        toolBar.addSeparator();
        JButton singleLineStepInto = PrimaryFrame.__barButton(toolBar, "Single Line Step Into", "format-indent-more");
        singleLineStepInto.addActionListener(this::__singleStepLineInto);
        JButton singleLineStepOver = PrimaryFrame.__barButton(toolBar, "Single Line Step Over", "format-justify-center");
        singleLineStepOver.addActionListener(this::__singleStepLineOver);
        JButton singleLineStepOut = PrimaryFrame.__barButton(toolBar, "Single Line Step Out", "edit-undo");
        singleLineStepOut.addActionListener(this::__singleStepLineOut);
        this.add((Component)toolBar, "First");
        this.statusPanel = statusPanel = new StatusPanel(__state);
        this.add((Component)statusPanel, "Last");
        Timer updateTimer = new Timer(30000, __ignored -> this.update());
        updateTimer.start();
    }

    public void handleSingleStep(DebuggerState __state, SingleStepEvent __event) {
        Debugging.debugNote("Single stepped.");
        this.statusPanel.setMessage("Single stepped.");
        InfoThread inThread = __event.thread;
        if (inThread != null) {
            inThread.frames.update(__state, (__ignored, __value) -> {
                InfoFrame[] frames = (InfoFrame[])__value.get();
                if (frames != null && frames.length > 0) {
                    this.context.set(frames[0]);
                }
                this.update();
            });
        }
        this.update();
    }

    public void update() {
        Utils.swingInvoke(() -> this.shownContext.update());
    }

    private void __inspect(StoredInfo<?> __stored) throws NullPointerException {
        Utils.inspect((Window)this, this.state, __stored);
    }

    private void __inspectCapabilities(ActionEvent __event) {
        InspectCapabilities inspect = new InspectCapabilities(this, this.state.capabilities);
        inspect.setLocationRelativeTo(null);
        inspect.setVisible(true);
    }

    private void __inspectThread(ActionEvent __event) {
        this.__inspect(this.state.storedInfo.getThreads());
    }

    private void __inspectType(ActionEvent __action) {
        DebuggerState state = this.state;
        try (JDWPPacket out = state.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.ALL_CLASSES);){
            state.send(out, (__state, __reply) -> {
                StoredInfo<InfoClass> classes = this.state.storedInfo.getClasses();
                int count = __reply.readInt();
                for (int i2 = 0; i2 < count; ++i2) {
                    __reply.readByte();
                    JDWPId typeId = __reply.readId(JDWPIdKind.REFERENCE_TYPE_ID);
                    String name = __reply.readString();
                    __reply.readInt();
                    InfoClass infoClass = classes.get(__state, typeId, new Object[0]);
                    if (infoClass == null) continue;
                    try {
                        infoClass.thisName.set(new FieldDescriptor(name).className());
                        continue;
                    }
                    catch (InvalidClassFormatException __e) {
                        __e.printStackTrace(System.err);
                    }
                }
                this.__inspect(state.storedInfo.getClasses());
            }, ReplyHandler.IGNORED);
        }
    }

    private void __paranoidThrows(ActionEvent __event) {
        DebuggerState state = this.state;
        for (String classNameRaw : Arrays.asList("java.io.IOException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.ArrayStoreException", "java.lang.AssertionError", "java.lang.ClassCastException", "java.lang.ClassNotFoundException", "java.lang.Error", "java.lang.IllegalAccessException", "java.lang.IllegalArgumentException", "java.lang.IllegalMonitorStateException", "java.lang.IllegalStateException", "java.lang.IllegalThreadStateException", "java.lang.IncompatibleClassChangeError", "java.lang.IndexOutOfBoundsException", "java.lang.InterruptedException", "java.lang.NegativeArraySizeException", "java.lang.NoClassDefFoundError", "java.lang.NoSuchFieldError", "java.lang.NullPointerException", "java.lang.NumberFormatException", "java.lang.OutOfMemoryError", "java.lang.RuntimeException", "java.lang.SecurityException", "java.lang.StackOverflowError", "java.lang.StringIndexOutOfBoundsException", "java.lang.Throwable", "java.lang.Throwable", "java.lang.UnsupportedClassVersionError", "java.lang.UnsupportedOperationException", "java.lang.VirtualMachineError")) {
            Debugging.debugNote("Paranoid: %s", classNameRaw);
            ClassName className = new ClassName(classNameRaw.replace('.', '/'));
            EventModifierClassMatch classMatch = new EventModifierClassMatch(classNameRaw);
            state.eventSet(JDWPEventKind.EXCEPTION, JDWPSuspendPolicy.ALL, new EventModifier[]{classMatch}, (__state, __reply) -> {}, null);
            state.eventSet(JDWPEventKind.EXCEPTION_CATCH, JDWPSuspendPolicy.ALL, new EventModifier[]{classMatch}, (__state, __reply) -> {}, null);
            state.lookupClass(className, __info -> {
                Debugging.debugNote("Catching: %s (%d)", className);
                InfoClass lookAt = __info[0];
                EventModifierClassOnly onlyClass = new EventModifierClassOnly(lookAt.id);
                state.eventSet(JDWPEventKind.EXCEPTION, JDWPSuspendPolicy.ALL, new EventModifier[]{onlyClass}, (__state, __reply) -> {}, null);
                state.eventSet(JDWPEventKind.EXCEPTION_CATCH, JDWPSuspendPolicy.ALL, new EventModifier[]{onlyClass}, (__state, __reply) -> {}, null);
                lookAt.methods();
                InfoMethod[] methods = lookAt.methods();
                if (methods != null) {
                    for (InfoMethod methodInfo : methods) {
                        RemoteMethodViewer mv = new RemoteMethodViewer(state, methodInfo);
                        mv.methodNameAndType();
                        MethodNameAndType nat = mv.methodNameAndType();
                        if (nat == null || !"<init>".equals(nat.name().toString())) continue;
                        EventModifierLocationOnly mod = new EventModifierLocationOnly(lookAt.id, methodInfo.id, 0L);
                        state.eventSet(JDWPEventKind.BREAKPOINT, JDWPSuspendPolicy.ALL, new EventModifier[]{mod}, (__state, __reply) -> {}, null);
                    }
                }
            }, __e -> Debugging.debugNote("Ignoring unknown: %s", className));
        }
    }

    private void __probeVendorCommands(ActionEvent __event) {
        if (0 == JOptionPane.showConfirmDialog(this, "This probes all 32768 vendor specific JDWP commands\nwhich may overload the JVM and/or cause it to crash\nand/or have undesired effects.\nYou have been warned, continue?", "Are you sure?", 0, 3, null)) {
            VendorCommandProbe probe = new VendorCommandProbe(this, this.state);
            probe.setLocationRelativeTo(null);
            probe.setVisible(true);
        }
    }

    private void __refresh(ActionEvent __event) {
        Utils.swingInvoke(() -> this.update());
    }

    private void __singleStepLineInto(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadStep(thread, 1, JDWPStepDepth.INTO, JDWPStepSize.LINE, this::handleSingleStep);
        }
        this.update();
    }

    private void __singleStepLineOut(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadStep(thread, 1, JDWPStepDepth.OUT, JDWPStepSize.LINE, this::handleSingleStep);
        }
        this.update();
    }

    private void __singleStepLineOver(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadStep(thread, 1, JDWPStepDepth.OVER, JDWPStepSize.LINE, this::handleSingleStep);
        }
        this.update();
    }

    private void __singleStepMinInto(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadStep(thread, 1, JDWPStepDepth.INTO, JDWPStepSize.MIN, this::handleSingleStep);
        }
        this.update();
    }

    private void __singleStepMinOut(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadStep(thread, 1, JDWPStepDepth.OUT, JDWPStepSize.MIN, this::handleSingleStep);
        }
        this.update();
    }

    private void __singleStepMinOver(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadStep(thread, 1, JDWPStepDepth.OVER, JDWPStepSize.MIN, this::handleSingleStep);
        }
        this.update();
    }

    private void __threadAllResume(ActionEvent __event) {
        this.state.threadResumeAll(() -> this.update());
    }

    private void __threadAllSuspend(ActionEvent __event) {
        this.state.threadSuspendAll(() -> this.update());
    }

    private void __threadSingleResume(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadResume(thread, () -> {
                thread.frames.drop();
                this.context.dropFrame(thread);
                this.update();
            });
        }
    }

    private void __threadSingleSuspend(ActionEvent __event) {
        InfoThread thread = this.context.getThread();
        if (thread != null) {
            this.state.threadSuspend(thread, () -> this.update());
        }
    }

    private void __viewClassDisk(ActionEvent __event) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Java Class Files", "class"));
        if (fileChooser.showOpenDialog(this) == 0) {
            try (InputStream in = Files.newInputStream(fileChooser.getSelectedFile().toPath(), StandardOpenOption.READ);){
                ClassFile classFile = ClassFile.decode(in);
                this.__viewClass(new JavaClassViewer(classFile));
            }
            catch (IOException __e) {
                Utils.throwableTraceDialog(this, "Failed to load class from disk", __e);
            }
        }
    }

    private void __viewClass(ClassViewer __viewer) throws NullPointerException {
        if (__viewer == null) {
            throw new NullPointerException("NARG");
        }
        ShownClassDialog dialog = new ShownClassDialog((Window)this, this.state, __viewer);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private void __viewClassLocal(ActionEvent __event) {
        String option = (String)JOptionPane.showInputDialog(this, "Choose local class", "Choose local class", 3, null, null, "java/lang/Class");
        if (option != null) {
            ClassName className;
            Object[] classFiles;
            if (option.indexOf(46) >= 0) {
                option = option.replace('.', '/');
            }
            if ((classFiles = Utils.loadClass(className = new ClassName(option), this.preferences)) == null || classFiles.length == 0) {
                Utils.throwableTraceDialog(this, "Could not find class: " + className, new Throwable());
                return;
            }
            ClassFile lookAt = classFiles.length == 1 ? classFiles[0] : (ClassFile)JOptionPane.showInputDialog(this, "Select class:", "Multiple classes found", 3, null, classFiles, classFiles[0]);
            if (lookAt != null) {
                this.__viewClass(new JavaClassViewer(lookAt));
            }
        }
    }

    private void __viewClassNetwork(ActionEvent __event) {
        String option = (String)JOptionPane.showInputDialog(this, "Choose remote class", "Choose remote class", 3, null, null, "java/lang/Class");
        if (option != null) {
            if (option.indexOf(46) >= 0) {
                option = option.replace('.', '/');
            }
            ClassName className = new ClassName(option);
            this.state.lookupClass(className, __info -> {
                InfoClass lookAt = ((InfoClass[])__info).length == 1 ? __info[0] : (InfoClass)JOptionPane.showInputDialog(this, "Select class:", "Multiple classes found", 3, null, __info, __info[0]);
                if (lookAt != null) {
                    this.__viewClass(new RemoteClassViewer(this.state, lookAt));
                }
            }, __e -> Utils.throwableTraceDialog(this, "Could not find class: " + className, __e));
        }
    }

    private static JButton __barButton(String __label, String __tango) throws NullPointerException {
        if (__label == null || __tango == null) {
            throw new NullPointerException("NARG");
        }
        JButton button = new JButton();
        button.setToolTipText(__label);
        button.setIcon(Utils.tangoIcon(__tango));
        return button;
    }

    private static JButton __barButton(JToolBar __toolBar, String __label, String __tango) throws NullPointerException {
        if (__toolBar == null) {
            throw new NullPointerException("NARG");
        }
        JButton button = PrimaryFrame.__barButton(__label, __tango);
        __toolBar.add(button);
        return button;
    }

    private static JMenuItem __menuItem(String __label, String __tango) throws NullPointerException {
        if (__label == null || __tango == null) {
            throw new NullPointerException("NARG");
        }
        return new JMenuItem(__label, Utils.tangoIcon(__tango));
    }
}

