/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.runtime.cldc.util.IntegerArrayList;
import net.multiphasicapps.classfile.ByteCodeUtils;
import net.multiphasicapps.classfile.InstructionMnemonics;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.classfile.Pool;

public class RemoteInstructionViewer
implements InstructionViewer {
    protected final int address;
    protected final byte[] byteCode;
    protected final KnownValue<Pool> pool;
    protected final DebuggerState state;
    private volatile Object[] _args;

    public RemoteInstructionViewer(DebuggerState __state, KnownValue<Pool> __pool, byte[] __byteCode, int __address) throws NullPointerException {
        if (__state == null || __byteCode == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.pool = __pool;
        this.byteCode = __byteCode;
        this.address = __address;
    }

    @Override
    public int address() {
        return this.address;
    }

    @Override
    public Object[] arguments() {
        Object[] result = this._args;
        if (result != null) {
            return (Object[])result.clone();
        }
        boolean cacheOkay = false;
        try {
            int[] rawArgs = ByteCodeUtils.readRawArguments(this.byteCode, 0, this.address);
            Pool pool = this.pool.getOrUpdateSync(this.state);
            if (pool == null) {
                result = new IntegerArrayList(rawArgs).toArray(new Integer[rawArgs.length]);
            } else {
                try {
                    result = ByteCodeUtils.processArguments(pool, this.mnemonicId(), this.address, rawArgs);
                    cacheOkay = true;
                }
                catch (InvalidClassFormatException __e) {
                    __e.printStackTrace();
                    result = new IntegerArrayList(rawArgs).toArray(new Integer[rawArgs.length]);
                }
            }
        }
        catch (InvalidClassFormatException __e) {
            __e.printStackTrace();
            result = new Object[]{};
        }
        if (cacheOkay) {
            this._args = result;
        }
        return (Object[])result.clone();
    }

    @Override
    public int length() {
        try {
            return ByteCodeUtils.instructionLength(this.byteCode, 0, this.address, null);
        }
        catch (InvalidClassFormatException ignored) {
            return 1;
        }
    }

    @Override
    public String mnemonic() {
        return InstructionMnemonics.toString(this.mnemonicId());
    }

    @Override
    public int mnemonicId() {
        int base = this.byteCode[this.address] & 0xFF;
        if (base == 196) {
            return base << 8 | this.byteCode[this.address + 1] & 0xFF;
        }
        return base;
    }
}

