/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.InfoByteCode;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.MethodViewer;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.MethodDescriptor;
import net.multiphasicapps.classfile.MethodFlags;
import net.multiphasicapps.classfile.MethodName;
import net.multiphasicapps.classfile.MethodNameAndType;

public class RemoteMethodViewer
implements MethodViewer {
    protected final InfoMethod info;
    protected final DebuggerState state;

    public RemoteMethodViewer(DebuggerState __state, InfoMethod __info) throws NullPointerException {
        if (__info == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.info = __info;
    }

    @Override
    public ClassName inClass() {
        return this.info.inClass.thisName();
    }

    @Override
    public InstructionViewer[] instructions() {
        if (this.isAbstract() || this.isNative()) {
            return new InstructionViewer[0];
        }
        InfoByteCode byteCode = this.info.byteCode.getOrUpdateSync(this.state);
        if (byteCode == null) {
            return new InstructionViewer[0];
        }
        return byteCode.instructions();
    }

    @Override
    public boolean isAbstract() {
        MethodFlags flags = this.info.flags.getOrUpdateSync(this.info.internalState());
        if (flags != null) {
            return flags.isAbstract();
        }
        return false;
    }

    @Override
    public boolean isNative() {
        MethodFlags flags = this.info.flags.getOrUpdateSync(this.info.internalState());
        if (flags != null) {
            return flags.isNative();
        }
        return false;
    }

    @Override
    public MethodNameAndType methodNameAndType() {
        InfoMethod info = this.info;
        DebuggerState state = info.internalState();
        MethodName name = info.name.getOrUpdateSync(state);
        MethodDescriptor type = info.type.getOrUpdateSync(state);
        return new MethodNameAndType(name, type);
    }
}

