/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class SequentialPanel {
    protected final JComponent viewPanel;
    protected final JPanel addPanel;
    protected final JLabel filler = new JLabel();
    private volatile boolean _hasItems;

    public SequentialPanel() {
        this(true);
    }

    public SequentialPanel(boolean __scroll) {
        JPanel panel;
        this.addPanel = panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        if (__scroll) {
            JScrollPane scroll = new JScrollPane(panel, 20, 31);
            scroll.getVerticalScrollBar().setUnitIncrement(scroll.getVerticalScrollBar().getUnitIncrement() * 8);
            scroll.setWheelScrollingEnabled(true);
            this.viewPanel = scroll;
        } else {
            this.viewPanel = panel;
        }
        panel.add(this.filler);
    }

    public void add(JComponent __component) throws NullPointerException {
        if (__component == null) {
            throw new NullPointerException("NARG");
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.weightx = 20.0;
        constraints.weighty = 0.0;
        this.addPanel.remove(this.filler);
        this.addPanel.add((Component)__component, constraints);
        constraints.weighty = 20.0;
        this.addPanel.add((Component)this.filler, constraints);
        this._hasItems = true;
        Utils.revalidate(this.addPanel);
        Utils.revalidate(this.viewPanel);
    }

    public boolean hasItems() {
        return this._hasItems;
    }

    public void lookAt(JComponent __component) throws NullPointerException {
        if (__component == null) {
            throw new NullPointerException("NARG");
        }
        JComponent viewPanel = this.viewPanel;
        if (viewPanel instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)viewPanel;
            JViewport viewport = scroll.getViewport();
            Rectangle viewRect = viewport.getViewRect();
            Rectangle bounds = __component.getBounds();
            viewport.setViewPosition(new Point(bounds.x, bounds.y - viewRect.height / 4));
            Utils.revalidate(scroll);
        }
    }

    public JComponent panel() {
        return this.viewPanel;
    }

    public void removeAll() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        this.addPanel.removeAll();
        constraints.weighty = 20.0;
        this.addPanel.add((Component)this.filler, constraints);
        this._hasItems = false;
        Utils.revalidate(this.addPanel);
        Utils.revalidate(this.viewPanel);
    }
}

