/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ClassViewer;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.MethodViewer;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.ShownMethod;
import cc.squirreljme.debugger.ShownTableOfContents;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.multiphasicapps.classfile.ClassName;

public class ShownClass
extends JPanel {
    protected final ClassViewer viewer;
    protected final JLabel whatLabel;
    protected final SequentialPanel seqPanel;
    protected final DebuggerState state;
    protected final ShownTableOfContents toc;
    private volatile ShownMethod[] _shownMethods;

    public ShownClass(ClassViewer __viewer, ShownTableOfContents __toc, DebuggerState __state) throws NullPointerException {
        this(__viewer, __toc, __state, true);
    }

    public ShownClass(ClassViewer __viewer, ShownTableOfContents __toc, DebuggerState __state, boolean __scroll) throws NullPointerException {
        if (__viewer == null) {
            throw new NullPointerException("NARG");
        }
        this.viewer = __viewer;
        this.toc = __toc;
        this.state = __state;
        this.setLayout(new BorderLayout());
        JLabel whatLabel = new JLabel();
        whatLabel.setHorizontalAlignment(0);
        this.add((Component)whatLabel, "First");
        this.whatLabel = whatLabel;
        SequentialPanel seqPanel = new SequentialPanel(__scroll);
        this.add((Component)seqPanel.panel(), "Center");
        this.seqPanel = seqPanel;
        Utils.swingInvoke(this::shownUpdate);
    }

    public void shownUpdate() {
        ClassName thisName;
        ClassViewer viewer = this.viewer;
        ShownMethod[] shownMethods = this._shownMethods;
        if (shownMethods == null) {
            MethodViewer[] methods = viewer.methods();
            if (methods == null) {
                return;
            }
            SequentialPanel seqPanel = this.seqPanel;
            DebuggerState state = this.state;
            int count = methods.length;
            shownMethods = new ShownMethod[count];
            for (int i2 = 0; i2 < count; ++i2) {
                ShownMethod shown;
                shownMethods[i2] = shown = new ShownMethod(state, methods[i2], null, true);
                seqPanel.add(shown);
            }
            this._shownMethods = shownMethods;
        }
        if ((thisName = this.viewer.thisName()) != null) {
            this.whatLabel.setText(thisName.toString());
        } else {
            this.whatLabel.setText("Unknown?");
        }
        for (ShownMethod shown : shownMethods) {
            shown.shownUpdate();
        }
        Utils.revalidate(this);
    }
}

