/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.Utils;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ShownContextFrame
extends JPanel
implements ContextThreadFrameListener {
    protected final ContextThreadFrame context;
    protected final InfoFrame frame;
    protected final JButton text;
    protected final JButton pointer;

    public ShownContextFrame(InfoFrame __frame, ContextThreadFrame __context) throws NullPointerException {
        JButton text;
        JButton pointer;
        if (__frame == null || __context == null) {
            throw new NullPointerException("NARG");
        }
        this.frame = __frame;
        this.context = __context;
        FlowLayout layout = new FlowLayout(3);
        layout.setHgap(0);
        layout.setVgap(0);
        this.setLayout(layout);
        this.pointer = pointer = new JButton();
        Utils.prettyTextButton(pointer);
        pointer.setIcon(Utils.tangoIcon("-"));
        this.add(pointer);
        this.text = text = new JButton(__frame.toString());
        Utils.prettyTextButton(text);
        this.add(text);
        text.addActionListener(this::__changeContext);
        __context.addListener(this);
        Utils.swingInvoke(this::update);
    }

    @Override
    public void contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        this.update();
    }

    public void update() {
        JButton pointer = this.pointer;
        InfoFrame inFrame = this.context.getFrame();
        if (Objects.equals(this.frame, inFrame)) {
            pointer.setIcon(Utils.tangoIcon("go-next"));
        } else {
            pointer.setIcon(Utils.tangoIcon("-"));
        }
        Utils.revalidate(this);
    }

    private void __changeContext(ActionEvent __event) {
        this.context.set(this.frame);
    }
}

