/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.JavaMethodViewer;
import cc.squirreljme.debugger.MethodViewer;
import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.debugger.RemoteMethodViewer;
import cc.squirreljme.debugger.ShownContextVariables;
import cc.squirreljme.debugger.ShownMethod;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.multiphasicapps.classfile.ClassFile;
import net.multiphasicapps.classfile.Method;
import net.multiphasicapps.classfile.MethodNameAndType;

public class ShownContextMethod
extends JPanel
implements ContextThreadFrameListener {
    protected final ContextThreadFrame context;
    protected final DebuggerState state;
    protected final JLabel info;
    protected final ShownContextVariables variables;
    protected final Preferences preferences;
    private volatile ShownMethod _shownMethod;
    private volatile InfoMethod _lookingAt;

    public ShownContextMethod(DebuggerState __state, ContextThreadFrame __context, Preferences __preferences) {
        ShownContextVariables variables;
        if (__state == null || __context == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.context = __context;
        this.preferences = __preferences;
        this.setLayout(new BorderLayout());
        JLabel info = new JLabel();
        info.setHorizontalAlignment(0);
        this.info = info;
        this.add((Component)info, "First");
        this.variables = variables = new ShownContextVariables(__state, __context);
        this.add((Component)variables, "Last");
        __context.addListener(this);
        Utils.swingInvoke(this::update);
    }

    @Override
    public void contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        this.update();
    }

    public void update() {
        InfoMethod inMethod;
        ShownMethod current = this._shownMethod;
        InfoFrame inFrame = this.context.getFrame();
        InfoMethod infoMethod = inMethod = inFrame == null ? null : inFrame.inMethod();
        if (inMethod == null || inFrame == null) {
            if (current != null) {
                this.remove(current);
                current = null;
            }
        } else if (current == null || !Objects.equals(this._lookingAt, inMethod)) {
            if (current != null) {
                this.remove(current);
                current = null;
            }
            if (inMethod != null) {
                RemoteMethodViewer remote = new RemoteMethodViewer(this.state, inMethod);
                Method localMethod = ShownContextMethod.__possiblyLocal(this.state, remote, this.preferences);
                MethodViewer viewer = localMethod != null ? new JavaMethodViewer(localMethod) : remote;
                this._shownMethod = current = new ShownMethod(this.state, viewer, this.context, true);
                this._lookingAt = inMethod;
                this.add((Component)current, "Center");
                current.shownUpdate();
            }
        } else {
            current.shownUpdate();
        }
        if (current == null) {
            this.info.setText("Nothing");
        } else {
            this.info.setText(String.format("%s @ %d", inMethod, inFrame.location.index));
        }
        this.variables.update();
        Utils.revalidate(this.info);
        Utils.revalidate(this);
    }

    private static Method __possiblyLocal(DebuggerState __state, MethodViewer __inMethod, Preferences __preferences) throws NullPointerException {
        if (__inMethod == null || __preferences == null) {
            throw new NullPointerException("NARG");
        }
        if (__inMethod.isAbstract() || __inMethod.isNative() || __inMethod.inClass() == null) {
            return null;
        }
        InstructionViewer[] instructions = __inMethod.instructions();
        if (instructions == null || instructions.length == 0 || __preferences.isLocalClassOnly()) {
            ClassFile[] classFiles = Utils.loadClass(__inMethod.inClass(), __preferences);
            if (classFiles == null || classFiles.length == 0) {
                return null;
            }
            MethodNameAndType wantNat = __inMethod.methodNameAndType();
            for (ClassFile classFile : classFiles) {
                for (Method method : classFile.methods()) {
                    if (!Objects.equals(wantNat, method.nameAndType())) continue;
                    return method;
                }
            }
        }
        return null;
    }
}

