/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoFrameLocals;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.KeyValuePanel;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.Utils;
import cc.squirreljme.jdwp.JDWPValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShownContextVariables
extends JPanel
implements ContextThreadFrameListener {
    protected final ContextThreadFrame context;
    protected final DebuggerState state;
    protected final SequentialPanel sequence;
    private final KeyValuePanel[] _keyValues;

    public ShownContextVariables(DebuggerState __state, ContextThreadFrame __context) throws NullPointerException {
        SequentialPanel sequence;
        if (__state == null || __context == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.context = __context;
        KeyValuePanel[] keyValues = new KeyValuePanel[127];
        int n2 = 127;
        for (int i2 = 0; i2 < n2; ++i2) {
            keyValues[i2] = new KeyValuePanel(new JLabel(Integer.toString(i2)), new JLabel());
        }
        this._keyValues = keyValues;
        this.setLayout(new BorderLayout());
        this.sequence = sequence = new SequentialPanel(true);
        this.add((Component)sequence.panel(), "Center");
        __context.addListener(this);
        Utils.swingInvoke(this::update);
    }

    @Override
    public void contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        this.update();
    }

    public void update() {
        SequentialPanel sequence = this.sequence;
        DebuggerState state = this.state;
        InfoFrame inFrame = this.context.getFrame();
        if (inFrame == null) {
            sequence.removeAll();
            return;
        }
        inFrame.variables.update(state, (__state, __value) -> {
            InfoFrameLocals locals = (InfoFrameLocals)__value.get();
            if (locals != null) {
                Utils.swingInvoke(() -> this.__updateLocals(locals));
            }
        });
        Utils.revalidate(this);
    }

    private void __updateLocals(InfoFrameLocals __locals) {
        SequentialPanel sequence = this.sequence;
        if (__locals == null) {
            return;
        }
        sequence.removeAll();
        KeyValuePanel[] keyValues = this._keyValues;
        int numLocals = 127;
        for (int index = 0; index < numLocals; ++index) {
            JDWPValue value = __locals.get(index);
            if (value == null) continue;
            KeyValuePanel keyValue = keyValues[index];
            JLabel subValue = (JLabel)keyValue.value;
            subValue.setText(Objects.toString(value, "null"));
            sequence.add(keyValue);
            Utils.revalidate(subValue);
            Utils.revalidate(keyValue);
        }
        Utils.revalidate(this);
    }
}

