/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.FrameLocationInterpret;
import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.Utils;
import java.awt.FlowLayout;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ShownInstruction
extends JPanel {
    protected final InstructionViewer viewer;
    protected final JButton breakpoint;
    protected final JTextField address;
    protected final JTextField description;
    protected final DebuggerState state;
    protected final ContextThreadFrame context;
    protected final int index;
    protected final JButton pointer;
    private final JButton[] _args;

    public ShownInstruction(DebuggerState __state, InstructionViewer __viewer, ContextThreadFrame __context, int __index) throws NullPointerException {
        if (__viewer == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.viewer = __viewer;
        this.context = __context;
        this.index = __index;
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        FlowLayout layout = new FlowLayout(0);
        layout.setHgap(4);
        layout.setVgap(0);
        this.setLayout(layout);
        if (__state == null) {
            this.breakpoint = null;
        } else {
            JButton breakpoint;
            this.breakpoint = breakpoint = new JButton();
            Utils.prettyTextButton(breakpoint);
            breakpoint.setIcon(Utils.tangoIcon("-"));
            this.add(breakpoint);
        }
        if (__context == null) {
            this.pointer = null;
        } else {
            JButton pointer;
            this.pointer = pointer = new JButton();
            Utils.prettyTextButton(pointer);
            pointer.setIcon(Utils.tangoIcon("-"));
            this.add(pointer);
        }
        JTextField address = new JTextField();
        Utils.prettyTextField(address);
        JTextField mnemonic = new JTextField();
        Utils.prettyTextField(mnemonic);
        mnemonic.setFont(mnemonic.getFont().deriveFont(1));
        Object[] rawArgs = __viewer.arguments();
        int argCount = rawArgs.length;
        JButton[] args = new JButton[argCount];
        for (int i2 = 0; i2 < argCount; ++i2) {
            JButton single = new JButton(Objects.toString(rawArgs[i2]));
            Utils.prettyTextButton(single);
            args[i2] = single;
        }
        this.add(address);
        this.add(mnemonic);
        for (JButton arg : args) {
            this.add(arg);
        }
        this.address = address;
        this.description = mnemonic;
        this._args = args;
        Utils.swingInvoke(() -> this.shownUpdate());
    }

    public boolean shownUpdate() {
        boolean isAt = false;
        InstructionViewer viewer = this.viewer;
        int pcAddr = viewer.address();
        int index = this.index;
        ContextThreadFrame context = this.context;
        if (context != null) {
            JButton pointer = this.pointer;
            FrameLocationInterpret interpret = this.state._locationInterpret;
            FrameLocation location = context.getLocation();
            if (location != null) {
                if (interpret == FrameLocationInterpret.ADDRESS) {
                    isAt = location.index == (long)pcAddr;
                } else {
                    boolean bl2 = isAt = location.index == (long)index;
                }
            }
            if (isAt) {
                pointer.setIcon(Utils.tangoIcon("go-next"));
            } else {
                pointer.setIcon(Utils.tangoIcon("-"));
            }
            Utils.revalidate(pointer);
        }
        this.address.setText(String.format("@%d", pcAddr));
        this.description.setText(viewer.mnemonic());
        Utils.revalidate(this.address);
        Utils.revalidate(this.description);
        Utils.revalidate(this);
        return isAt;
    }
}

