/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoByteCode;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.InstructionViewer;
import cc.squirreljme.debugger.MethodViewer;
import cc.squirreljme.debugger.RemoteMethodViewer;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.ShownInstruction;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShownMethod
extends JPanel
implements ContextThreadFrameListener {
    protected final MethodViewer viewer;
    protected final JLabel whatLabel;
    protected final SequentialPanel seqPanel;
    protected final DebuggerState state;
    protected final ContextThreadFrame context;
    private volatile ShownInstruction[] _shownInstructions;

    public ShownMethod(DebuggerState __state, MethodViewer __viewer, ContextThreadFrame __context, boolean __scroll) throws NullPointerException {
        if (__viewer == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.context = __context;
        this.viewer = __viewer;
        this.setLayout(new BorderLayout());
        JLabel whatLabel = new JLabel();
        whatLabel.setHorizontalAlignment(0);
        this.add((Component)whatLabel, "First");
        this.whatLabel = whatLabel;
        SequentialPanel seqPanel = new SequentialPanel(__scroll);
        this.add((Component)seqPanel.panel(), "Center");
        this.seqPanel = seqPanel;
        if (__context != null) {
            __context.addListener(this);
        }
        Utils.swingInvoke(this::shownUpdate);
    }

    @Override
    public void contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        Utils.swingInvoke(this::shownUpdate);
    }

    public void shownUpdate() {
        MethodViewer viewer = this.viewer;
        this.whatLabel.setText(String.format("%s%s%s::%s", viewer.isNative() ? "native " : "", viewer.isAbstract() ? "abstract " : "", viewer.inClass(), viewer.methodNameAndType()));
        Utils.revalidate(this.whatLabel);
        if (viewer.isNative() || viewer.isAbstract()) {
            return;
        }
        ShownInstruction[] shownInstructions = this._shownInstructions;
        if (shownInstructions == null) {
            if (viewer instanceof RemoteMethodViewer) {
                ((RemoteMethodViewer)viewer).info.byteCode.update(this.state, (__state, __value) -> {
                    InfoByteCode byteCode = (InfoByteCode)__value.get();
                    if (byteCode != null) {
                        Utils.swingInvoke(() -> this.__updateInstructions(byteCode.instructions()));
                    }
                });
            } else {
                this.__updateInstructions(viewer.instructions());
            }
        }
        if ((shownInstructions = this._shownInstructions) != null) {
            for (ShownInstruction shown : shownInstructions) {
                if (!shown.shownUpdate()) continue;
                this.seqPanel.lookAt(shown);
            }
        }
        Utils.revalidate(this);
    }

    private void __updateInstructions(InstructionViewer[] __instructions) {
        if (__instructions == null) {
            return;
        }
        SequentialPanel seqPanel = this.seqPanel;
        if (seqPanel.hasItems()) {
            this.shownUpdate();
            return;
        }
        DebuggerState state = this.state;
        ContextThreadFrame context = this.context;
        int count = __instructions.length;
        ShownInstruction[] shownInstructions = new ShownInstruction[count];
        for (int i2 = 0; i2 < count; ++i2) {
            ShownInstruction shown;
            shownInstructions[i2] = shown = new ShownInstruction(state, __instructions[i2], context, i2);
            seqPanel.add(shown);
            shown.shownUpdate();
        }
        this._shownInstructions = shownInstructions;
        this.shownUpdate();
    }
}

