/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.ShownContextFrame;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.multiphasicapps.classfile.ClassName;

public class ShownThread
extends JPanel
implements ContextThreadFrameListener {
    protected final InfoThread thread;
    protected final DebuggerState state;
    protected final JLabel suspendLabel;
    protected final SequentialPanel sequence;
    protected final ContextThreadFrame context;

    public ShownThread(DebuggerState __state, InfoThread __thread, ContextThreadFrame __context) throws NullPointerException {
        SequentialPanel sequence;
        JLabel suspendLabel;
        if (__state == null || __thread == null || __context == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.thread = __thread;
        this.context = __context;
        __context.addListener(this);
        this.setLayout(new BorderLayout());
        this.suspendLabel = suspendLabel = new JLabel();
        this.add((Component)suspendLabel, "First");
        this.sequence = sequence = new SequentialPanel(true);
        this.add((Component)sequence.panel(), "Center");
        Utils.swingInvoke(this::update);
    }

    @Override
    public void contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        this.update();
    }

    public void update() {
        InfoThread inThread = this.thread;
        DebuggerState state = this.state;
        inThread.suspendCount.update(state, (__state, __value) -> {
            int count = (Integer)__value.get();
            Utils.swingInvoke(() -> this.__updateSuspend(count));
        });
        inThread.frames.update(state, (__state, __value) -> {
            InfoFrame[] frames = (InfoFrame[])__value.get();
            Utils.swingInvoke(() -> this.__updateFrames(frames));
        });
        Utils.revalidate(this);
    }

    private void __updateFrames(InfoFrame[] __frames) {
        SequentialPanel sequence = this.sequence;
        if (__frames == null || __frames.length == 0) {
            return;
        }
        sequence.removeAll();
        ContextThreadFrame context = this.context;
        InfoClass currentClass = null;
        for (InfoFrame frame : __frames) {
            InfoClass newClass = frame.location.inClass;
            if (currentClass == null && newClass != null || !Objects.equals(currentClass, newClass)) {
                ClassName newThisName = newClass.thisName();
                JLabel atClass = new JLabel(Objects.toString(newThisName, "null"));
                atClass.setFont(atClass.getFont().deriveFont(2));
                sequence.add(atClass);
                currentClass = newClass;
            }
            ShownContextFrame shownFrame = new ShownContextFrame(frame, context);
            sequence.add(shownFrame);
            shownFrame.update();
        }
        Utils.revalidate(this);
    }

    private void __updateSuspend(int __count) {
        JLabel suspendLabel = this.suspendLabel;
        if (__count > 0) {
            suspendLabel.setText(String.format("Suspended %d time%s.", __count, __count == 1 ? "" : "s"));
        } else {
            suspendLabel.setText("Running");
        }
        Utils.revalidate(this);
    }
}

