/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.ShownThread;
import cc.squirreljme.debugger.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ShownThreads
extends JPanel
implements ContextThreadFrameListener {
    protected final DebuggerState state;
    protected final JComboBox<InfoThread> combo;
    protected final ContextThreadFrame context;
    private final ActionListener _actionListener;
    private final ItemListener _itemListener;
    private volatile ShownThread _current;
    private volatile InfoThread[] _lastKnown;

    public ShownThreads(DebuggerState __state, ContextThreadFrame __context) throws NullPointerException {
        if (__state == null || __context == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.context = __context;
        JComboBox combo = new JComboBox();
        this.combo = combo;
        this.setLayout(new BorderLayout());
        this.add(combo, "First");
        this._actionListener = this::__chooseThread;
        this._itemListener = this::__chooseThread;
        combo.addActionListener(this._actionListener);
        combo.addItemListener(this._itemListener);
        this._lastKnown = new InfoThread[0];
        Timer tick = new Timer(5000, __event -> this.__updateAll());
        tick.setInitialDelay(3000);
        tick.start();
    }

    @Override
    public void contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        this.__updateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object[] threads;
        ShownThreads shownThreads = this;
        synchronized (shownThreads) {
            threads = this._lastKnown;
        }
        if (threads == null || threads.length == 0) {
            return;
        }
        InfoThread contextThread = this.context.getThread();
        Arrays.sort(threads);
        JComboBox<InfoThread> combo = this.combo;
        combo.removeActionListener(this._actionListener);
        combo.removeItemListener(this._itemListener);
        InfoThread selected = (InfoThread)combo.getSelectedItem();
        boolean redoSelection = false;
        boolean didFind = false;
        for (int i2 = combo.getItemCount() - 1; i2 >= 0; --i2) {
            InfoThread at2 = combo.getItemAt(i2);
            int found = -1;
            if (at2 != null && !at2.isDisposed() && !at2.isDead.getOrDefault(false).booleanValue()) {
                int m2 = threads.length;
                for (int j2 = 0; j2 < m2; ++j2) {
                    if (!Objects.equals(at2, threads[j2])) continue;
                    found = j2;
                    break;
                }
            }
            if (found < 0) {
                if (Objects.equals(selected, at2)) {
                    redoSelection = true;
                }
                combo.removeItemAt(i2);
                continue;
            }
            didFind = true;
            threads[found] = null;
        }
        for (Object thread : threads) {
            if (thread == null) continue;
            combo.addItem((InfoThread)thread);
        }
        if (!didFind || redoSelection || contextThread == null) {
            Object forceSelect = threads[0];
            combo.setSelectedItem(forceSelect);
            this.context.optional((InfoThread)forceSelect);
        } else {
            combo.setSelectedItem(contextThread);
        }
        combo.addActionListener(this._actionListener);
        combo.addItemListener(this._itemListener);
        if (this._current == null && contextThread != null) {
            this.__context(contextThread);
        }
        Utils.revalidate(combo);
        Utils.revalidate(this);
    }

    private void __chooseThread(ActionEvent __event) {
        InfoThread thread = (InfoThread)this.combo.getSelectedItem();
        if (thread != null) {
            this.context.set(this.state, thread);
            Utils.swingInvoke(() -> this.__context(thread));
        }
    }

    private void __chooseThread(ItemEvent __event) {
        InfoThread thread = (InfoThread)__event.getItem();
        if (thread == null || __event.getStateChange() != 1) {
            return;
        }
        if (thread != null) {
            this.context.set(this.state, thread);
            Utils.swingInvoke(() -> this.__context(thread));
        }
    }

    private void __context(InfoThread __context) {
        ShownThread shown = this._current;
        if (shown != null && __context != null && !Objects.equals(shown.thread, __context)) {
            this._current = null;
            this.remove(shown);
            shown = null;
        }
        if (shown == null && __context != null) {
            shown = new ShownThread(this.state, __context, this.context);
            this.add((Component)shown, "Center");
            this._current = shown;
            shown.update();
        } else if (shown != null) {
            shown.update();
        }
        Utils.revalidate(this);
    }

    private void __updateAll() {
        this.state.allThreads(__threads -> {
            ShownThreads shownThreads = this;
            synchronized (shownThreads) {
                this._lastKnown = __threads;
            }
            Utils.swingInvoke(this::update);
        });
    }
}

