/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.TallyListener;
import cc.squirreljme.debugger.TallyTracker;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class StatusPanel
extends JPanel
implements TallyListener {
    protected final DebuggerState debuggerState;
    protected final JLabel stateLabel;
    protected final JLabel receivedLabel;
    protected final JLabel sentLabel;
    protected final JLabel waitingLabel;
    protected final JLabel latencyLabel;
    protected final JLabel message;
    private volatile int _maxLatency;

    public StatusPanel(DebuggerState __state) throws NullPointerException {
        if (__state == null) {
            throw new NullPointerException("NARG");
        }
        this.debuggerState = __state;
        Font baseLabelFont = new JLabel().getFont();
        this.setMinimumSize(new Dimension(320, baseLabelFont.getSize()));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        FlowLayout layout = new FlowLayout(3, 0, 0);
        layout.setAlignOnBaseline(true);
        this.setLayout(layout);
        JLabel stateLabel = new JLabel("CONNECTED");
        this.__pretty(stateLabel);
        this.stateLabel = stateLabel;
        JLabel receivedLabel = new JLabel();
        this.__pretty(receivedLabel);
        this.receivedLabel = receivedLabel;
        JLabel sentLabel = new JLabel();
        this.__pretty(sentLabel);
        this.sentLabel = sentLabel;
        JLabel waitingLabel = new JLabel();
        this.__pretty(waitingLabel);
        this.waitingLabel = waitingLabel;
        JLabel latencyLabel = new JLabel();
        this.__pretty(latencyLabel);
        this.latencyLabel = latencyLabel;
        JLabel message = new JLabel();
        this.__pretty(message);
        this.message = message;
        this.add(stateLabel);
        this.add(receivedLabel);
        this.add(sentLabel);
        this.add(waitingLabel);
        this.add(latencyLabel);
        this.add(message);
        __state.receiveTally.addListener(this);
        __state.sentTally.addListener(this);
        __state.waitingTally.addListener(this);
        __state.latency.addListener(this);
        __state.disconnectedTally.addListener(this);
        __state.vmDeadTally.addListener(this);
    }

    public void setMessage(String __message) {
        this.message.setText(__message);
    }

    @Override
    public void updateTally(TallyTracker __which, int __old, int __new) {
        DebuggerState state = this.debuggerState;
        if (__which == state.receiveTally) {
            this.receivedLabel.setText(String.format("Received: %d", __new));
        } else if (__which == state.sentTally) {
            this.sentLabel.setText(String.format("Sent: %d", __new));
        } else if (__which == state.waitingTally) {
            this.waitingLabel.setText(String.format("Waiting: %d", __new));
        } else if (__which == state.latency) {
            int max;
            this._maxLatency = max = Math.max(__new, this._maxLatency);
            this.latencyLabel.setText(String.format("Latency: %d ms (max %d ms)", __new, max));
        } else if (__which == state.disconnectedTally || __which == state.vmDeadTally) {
            if (state.vmDeadTally.get() > 0) {
                this.stateLabel.setText("DEAD");
            } else {
                this.stateLabel.setText("DISCONNECTED");
            }
        }
    }

    private void __pretty(JLabel __label) throws NullPointerException {
        if (__label == null) {
            throw new NullPointerException("NARG");
        }
        __label.setBorder(new BevelBorder(1));
    }
}

