/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ForgettableStoredInfo;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoByteCode;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.PersistentStoredInfo;
import cc.squirreljme.debugger.StoredInfo;

public class StoredInfoManager {
    private final StoredInfo[] _infos;

    public StoredInfoManager() {
        InfoKind[] types = InfoKind.values();
        int numTypes = types.length;
        StoredInfo[] infos = new StoredInfo[numTypes];
        for (int i2 = 0; i2 < numTypes; ++i2) {
            infos[i2] = types[i2].isForgettable() ? new ForgettableStoredInfo(types[i2]) : new PersistentStoredInfo(types[i2]);
        }
        this._infos = infos;
    }

    public final <I extends Info> StoredInfo<I> get(Class<I> __class, InfoKind __type) throws NullPointerException {
        if (__class == null || __type == null) {
            throw new NullPointerException("NARG");
        }
        return this._infos[__type.ordinal()];
    }

    public StoredInfo<InfoByteCode> getByteCodes() {
        return this.get(InfoByteCode.class, InfoKind.BYTE_CODE);
    }

    public StoredInfo<InfoClass> getClasses() {
        return this.get(InfoClass.class, InfoKind.CLASS);
    }

    public final StoredInfo<InfoThread> getThreads() {
        return this.get(InfoThread.class, InfoKind.THREAD);
    }
}

