/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.Info;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.debugger.InfoMethod;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.Inspect;
import cc.squirreljme.debugger.InspectClass;
import cc.squirreljme.debugger.InspectMethod;
import cc.squirreljme.debugger.InspectThread;
import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.debugger.PrimaryFrame;
import cc.squirreljme.debugger.StoredInfo;
import cc.squirreljme.runtime.cldc.util.StreamUtils;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.multiphasicapps.classfile.BinaryName;
import net.multiphasicapps.classfile.ClassFile;
import net.multiphasicapps.classfile.ClassIdentifier;
import net.multiphasicapps.classfile.ClassName;
import net.multiphasicapps.classfile.InvalidClassFormatException;
import net.multiphasicapps.zip.ZipException;
import net.multiphasicapps.zip.blockreader.FileChannelBlockAccessor;
import net.multiphasicapps.zip.blockreader.ZipBlockEntry;
import net.multiphasicapps.zip.blockreader.ZipBlockReader;
import org.freedesktop.tango.TangoIconLoader;

public final class Utils {
    public static final int SHORT_TIMEOUT = 1000;
    public static final int TIMEOUT = 3000;
    public static final int IMPORTANT_TIMEOUT = 30000;

    private Utils() {
    }

    private static Path classDirName(BinaryName __name) throws NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        List<ClassIdentifier> names = __name.identifiers();
        Path result = null;
        int n2 = names.size() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassIdentifier name = names.get(i2);
            result = result == null ? Paths.get(name.toString(), new String[0]) : result.resolve(name.toString());
        }
        String baseName = names.get(names.size() - 1).toString() + ".class";
        if (result == null) {
            return Paths.get(baseName, new String[0]);
        }
        return result.resolve(baseName);
    }

    public static ClassFile[] loadClass(ClassName __name, Preferences __prefs) throws NullPointerException {
        if (__name == null || __prefs == null) {
            throw new NullPointerException("NARG");
        }
        BinaryName binaryName = __name.binaryName();
        if (binaryName == null || __name.isArray() || __name.isPrimitive()) {
            return null;
        }
        Path dirName = Utils.classDirName(binaryName);
        String zipName = binaryName + ".class";
        ArrayList<ClassFile> result = new ArrayList<ClassFile>();
        for (Path searchPath : __prefs.getClassSearchPath()) {
            try {
                Throwable throwable;
                Path wantDir = searchPath.resolve(dirName);
                if (Files.exists(wantDir, new LinkOption[0])) {
                    try {
                        throwable = null;
                        try (InputStream in = Files.newInputStream(wantDir, StandardOpenOption.READ);){
                            result.add(ClassFile.decode(in));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException | InvalidClassFormatException in) {
                        // empty catch block
                    }
                }
                try {
                    ZipBlockReader zip = new ZipBlockReader(new FileChannelBlockAccessor(searchPath));
                    throwable = null;
                    try {
                        ZipBlockEntry entry = zip.get(zipName);
                        if (entry == null) continue;
                        InputStream in = entry.open();
                        Throwable throwable3 = null;
                        try {
                            result.add(ClassFile.decode(in));
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable3 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (zip == null) continue;
                        if (throwable != null) {
                            try {
                                zip.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        zip.close();
                    }
                }
                catch (ZipException zipException) {
                }
            }
            catch (IOException iOException) {}
        }
        return result.toArray(new ClassFile[result.size()]);
    }

    public static void inspect(Window __owner, DebuggerState __state, InfoKind __kind, Info[] __items) throws NullPointerException {
        if (__state == null || __items == null) {
            throw new NullPointerException("NARG");
        }
        Object result = JOptionPane.showInputDialog(__owner, String.format("Select a %s to inspect", __kind == null ? "thing" : __kind.singular), String.format("Choosing a %s", __kind == null ? "thing" : __kind.singular), 3, null, __items, __items[0]);
        if (result != null) {
            Utils.inspect(__owner, __state, (Info)result);
        }
    }

    public static void inspect(Window __owner, DebuggerState __state, StoredInfo<?> __stored) throws NullPointerException {
        if (__state == null || __stored == null) {
            throw new NullPointerException("NARG");
        }
        InfoKind type = __stored.type;
        Info[] all = __stored.all(__state);
        if (all.length == 0) {
            JOptionPane.showMessageDialog(__owner, String.format("There are no %s.", type.plural), "Error", 0, null);
            return;
        }
        Utils.inspect(__owner, __state, __stored.type, all);
    }

    public static void inspect(Window __owner, DebuggerState __state, Info __info) throws NullPointerException {
        Inspect dialog;
        if (__state == null || __info == null) {
            throw new NullPointerException("NARG");
        }
        switch (__info.kind) {
            case CLASS: {
                dialog = new InspectClass(__owner, __state, (InfoClass)__info);
                break;
            }
            case METHOD: {
                dialog = new InspectMethod(__owner, __state, (InfoMethod)__info);
                break;
            }
            case THREAD: {
                dialog = new InspectThread(__owner, __state, (InfoThread)__info);
                break;
            }
            default: {
                return;
            }
        }
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image lexIcon() {
        try (InputStream in = PrimaryFrame.class.getResourceAsStream("icon.png");){
            if (in == null) return null;
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void maximize(JFrame __frame) throws NullPointerException {
        if (__frame == null) {
            throw new NullPointerException("NARG");
        }
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            __frame.setMaximizedBounds(env.getMaximumWindowBounds());
        }
        __frame.setExtendedState(__frame.getExtendedState() | 6);
    }

    public static void prettyTextButton(JButton __button) throws NullPointerException {
        if (__button == null) {
            throw new NullPointerException("NARG");
        }
        __button.setBorder(new EmptyBorder(0, 0, 0, 0));
        __button.setBorderPainted(false);
        __button.setContentAreaFilled(false);
        __button.setHorizontalAlignment(2);
        __button.setBorder(new EmptyBorder(0, 0, 0, 0));
        Font descFont = __button.getFont();
        __button.setFont(new Font("monospaced", descFont.getStyle(), descFont.getSize()));
    }

    public static void prettyTextField(JTextField __label) throws NullPointerException {
        if (__label == null) {
            throw new NullPointerException("NARG");
        }
        __label.setBorder(new EmptyBorder(0, 0, 0, 0));
        __label.setHorizontalAlignment(2);
        __label.setEditable(false);
        __label.setBorder(new EmptyBorder(0, 0, 0, 0));
        Font descFont = __label.getFont();
        __label.setFont(new Font("monospaced", descFont.getStyle(), descFont.getSize()));
    }

    public static void revalidate(JComponent __component) throws NullPointerException {
        if (__component == null) {
            throw new NullPointerException("NARG");
        }
        __component.revalidate();
        __component.repaint();
    }

    public static void setIcon(Window __window) throws NullPointerException {
        if (__window == null) {
            throw new NullPointerException("NARG");
        }
        __window.setIconImage(Utils.lexIcon());
    }

    public static void swingInvoke(Runnable __run) throws NullPointerException {
        if (__run == null) {
            throw new NullPointerException("NARG");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            __run.run();
        } else {
            SwingUtilities.invokeLater(__run);
        }
    }

    public static String throwableTrace(Throwable __e) {
        String message;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");){
            __e.printStackTrace(ps);
            ps.flush();
            message = baos.toString("utf-8");
        }
        catch (IOException __f) {
            message = "Could not emit trace, check stderr.";
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon tangoIcon(String __name) throws NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        if (__name.equals("-")) return new ImageIcon(new BufferedImage(16, 16, 2));
        try (InputStream in = TangoIconLoader.loadIcon(16, __name);){
            if (in == null) return new ImageIcon(new BufferedImage(16, 16, 2));
            ImageIcon imageIcon = new ImageIcon(StreamUtils.readAll(in));
            return imageIcon;
        }
        catch (IOException __e) {
            __e.printStackTrace();
        }
        return new ImageIcon(new BufferedImage(16, 16, 2));
    }

    public static void throwableTraceDialog(JFrame __parent, String __title, Throwable __e) throws NullPointerException {
        JOptionPane.showMessageDialog(__parent, Utils.throwableTrace(__e), __title, 0);
    }
}

