/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.KeyValuePanel;
import cc.squirreljme.debugger.PrimaryFrame;
import cc.squirreljme.debugger.SequentialPanel;
import cc.squirreljme.debugger.Utils;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPPacket;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class VendorCommandProbe
extends JDialog
implements Runnable {
    public static final int COMMAND_SET_START = 128;
    public static final int COMMAND_SET_END = 255;
    public static final int COMMAND_SET_COUNT = 128;
    public static final int COMMAND_START = 0;
    public static final int COMMAND_END = 255;
    public static final int COMMAND_COUNT = 256;
    public static final int TOTAL_COUNT = 32768;
    protected final SequentialPanel sequence;
    protected final DebuggerState state;
    private final JLabel[] labels;

    public VendorCommandProbe(PrimaryFrame __owner, DebuggerState __state) throws NullPointerException {
        super(__owner);
        SequentialPanel sequence;
        if (__state == null) {
            throw new NullPointerException("NARG");
        }
        this.state = __state;
        this.setTitle("VM Command Probe");
        Utils.setIcon(this);
        this.setMinimumSize(new Dimension(300, 300));
        JLabel[] labels = new JLabel[32768];
        for (int i2 = 0; i2 < 32768; ++i2) {
            labels[i2] = new JLabel("Unknown");
        }
        this.labels = labels;
        this.sequence = sequence = new SequentialPanel(true);
        for (int i3 = 0; i3 < 32768; ++i3) {
            sequence.add(new KeyValuePanel(new JLabel(String.format("%d.%d", i3 / 256 + 128, i3 % 256)), labels[i3]));
        }
        this.add(sequence.panel());
        new Thread(this, "JDWPCommandProbe").start();
    }

    @Override
    public void run() {
        DebuggerState state = this.state;
        for (int commandSet = 128; commandSet <= 255; ++commandSet) {
            int command = 0;
            while (command <= 255) {
                try (JDWPPacket out = state.request(commandSet, command);){
                    int copyCommandSet = commandSet;
                    int copyCommand = command++;
                    state.send(out, (__state, __reply) -> this.__result(copyCommandSet, copyCommand, JDWPErrorType.NO_ERROR), (__state, __reply) -> this.__result(copyCommandSet, copyCommand, __reply.error()));
                }
            }
        }
    }

    public void update() {
        Utils.revalidate(this.sequence.panel());
    }

    private void __result(int __commandSet, int __command, JDWPErrorType __error) {
        int index = (__commandSet - 128) * 256 + __command;
        Utils.swingInvoke(() -> {
            JLabel label = this.labels[index];
            label.setText(Objects.toString(__error, "null"));
            Utils.revalidate(label);
            this.update();
        });
    }
}

