/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.emulator.EmulatedAudioConnectionBracket;
import cc.squirreljme.emulator.EmulatedAudioSourceBracket;
import cc.squirreljme.emulator.EmulatedAudioStreamBracket;
import cc.squirreljme.emulator.NativeBinding;
import cc.squirreljme.jvm.mle.brackets.AudioConnectionBracket;
import cc.squirreljme.jvm.mle.brackets.AudioStreamBracket;
import cc.squirreljme.jvm.mle.brackets.MidiPortBracket;
import cc.squirreljme.jvm.mle.callbacks.AudioStreamPlayer;
import cc.squirreljme.jvm.mle.callbacks.AudioStreamRenderer;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class EmulatedAudioStreamShelf {
    static volatile EmulatedAudioStreamBracket _stream;
    static volatile long _statePtr;

    private EmulatedAudioStreamShelf() {
    }

    @SquirrelJMEVendorApi
    public static AudioConnectionBracket attach(@NotNull AudioStreamBracket __stream, @NotNull AudioStreamRenderer __renderer, int __format, int __rate, int __channels) throws MLECallError {
        if (__stream == null || __renderer == null) {
            throw new MLECallError("NARG");
        }
        long statePtr = EmulatedAudioStreamShelf.__dylibInit();
        return new EmulatedAudioSourceBracket(statePtr, EmulatedAudioStreamShelf.__attach(statePtr, ((EmulatedAudioStreamBracket)__stream).streamPtr, __renderer, __format, __rate, __channels), (EmulatedAudioStreamBracket)__stream, __renderer);
    }

    @SquirrelJMEVendorApi
    @NotNull
    public static AudioStreamPlayer decoder(@Nullable String __urlOrFile, @Nullable @Language(value="mime-type-reference") String __mimeType, int __format, int __rate, int __channels, @NotNull byte[] __buf, @Range(from=0L, to=0x7FFFFFFFL) int __off, @Range(from=0L, to=0x7FFFFFFFL) int __len) throws MLECallError {
        if (__urlOrFile == null && __mimeType == null) {
            throw new MLECallError("NARG");
        }
        if (__format < -1 || __format >= 4 || __rate < -1 || __channels <= 0) {
            throw new MLECallError("Invalid rate/format/channels");
        }
        long statePtr = EmulatedAudioStreamShelf.__dylibInit();
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    public static boolean decoderSupports(@NotNull @Language(value="mime-type-reference") String __contentType) throws MLECallError {
        if (__contentType == null) {
            throw new MLECallError("NARG");
        }
        switch (__contentType) {
            default: 
        }
        return false;
    }

    @SquirrelJMEVendorApi
    public static void disconnect(@NotNull AudioConnectionBracket __conn) throws MLECallError {
        if (__conn == null) {
            throw new MLECallError("NARG");
        }
        long statePtr = EmulatedAudioStreamShelf.__dylibInit();
        EmulatedAudioStreamShelf.__disconnect(statePtr, ((EmulatedAudioConnectionBracket)__conn).instancePtr);
    }

    @SquirrelJMEVendorApi
    @NotNull
    public static MidiPortBracket midiPort(@NotNull @Language(value="mime-type-reference") String __mimeType, int __format, int __rate, int __channels) throws MLECallError {
        if (__mimeType == null) {
            throw new MLECallError("NARG");
        }
        if (__format < -1 || __format >= 4 || __rate < -1 || __channels <= 0) {
            throw new MLECallError("Invalid rate/format/channels");
        }
        long statePtr = EmulatedAudioStreamShelf.__dylibInit();
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    @NotNull
    public static AudioStreamRenderer midiRenderer(@NotNull MidiPortBracket __midiPort) throws MLECallError {
        if (__midiPort == null) {
            throw new MLECallError("NARG");
        }
        long statePtr = EmulatedAudioStreamShelf.__dylibInit();
        throw Debugging.todo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @SquirrelJMEVendorApi
    public static AudioStreamBracket stream() throws MLECallError {
        long statePtr = EmulatedAudioStreamShelf.__dylibInit();
        Class<EmulatedAudioStreamShelf> clazz = EmulatedAudioStreamShelf.class;
        synchronized (EmulatedAudioStreamShelf.class) {
            EmulatedAudioStreamBracket result = _stream;
            if (result != null) {
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return result;
            }
            _stream = result = new EmulatedAudioStreamBracket(statePtr, EmulatedAudioStreamShelf.__stream(statePtr));
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return result;
        }
    }

    static native long __attach(long var0, long var2, AudioStreamRenderer var4, int var5, int var6, int var7) throws MLECallError;

    private static native void __disconnect(long var0, long var2) throws MLECallError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long __dylibInit() {
        Class<EmulatedAudioStreamShelf> clazz = EmulatedAudioStreamShelf.class;
        synchronized (EmulatedAudioStreamShelf.class) {
            if (_statePtr != 0L) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return _statePtr;
            }
            for (String order : EmulatedAudioStreamShelf.__dylibOrder()) {
                long maybe = EmulatedAudioStreamShelf.__dylibInit(order);
                if (maybe == 0L) continue;
                _statePtr = maybe;
                // ** MonitorExit[var0] (shouldn't be in output)
                return maybe;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            throw new MLECallError("No audio support");
        }
    }

    static long __dylibInit(String __name) throws NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        try {
            String libName = System.mapLibraryName((String)("squirreljme-scritchaudio-" + __name));
            Path path = NativeBinding.libFromResources(libName, false);
            return EmulatedAudioStreamShelf.__dylibLoad(path.toAbsolutePath().toString(), __name.toLowerCase());
        }
        catch (MLECallError | LinkageError __e) {
            __e.printStackTrace();
            return 0L;
        }
    }

    static native long __dylibLoad(String var0, String var1) throws MLECallError;

    static List<String> __dylibOrder() {
        switch (NativeBinding.nativeOs()) {
            case "windows": {
                return Arrays.asList("pulse", "winmm");
            }
            case "macos": {
                return Arrays.asList("pulse", "coreaudio");
            }
        }
        return Arrays.asList("pulse", "alsa", "oss");
    }

    @SquirrelJMEVendorApi
    static void __render(AudioStreamRenderer __conn, ByteBuffer __buf, long __clock, int __samples, int __totalSamples, int __bytesPerSample, int __bufSize, int __format, int __rate, int __channels) {
        if (__conn == null || __buf == null) {
            throw new MLECallError("NARG");
        }
        if (!(__conn instanceof AudioStreamRenderer)) {
            throw new MLECallError("CAST");
        }
        AudioStreamRenderer renderer = __conn;
        __buf.order(ByteOrder.nativeOrder());
        int lowerBufLen = __bufSize / __bytesPerSample;
        Object[] lowerBuf = __format == 3 ? new float[lowerBufLen] : (__format == 2 ? (Object[])new int[lowerBufLen] : (__format == 1 ? (Object[])new short[lowerBufLen] : (Object[])new byte[lowerBufLen]));
        renderer.render(__format, __rate, __channels, lowerBuf, 0, __bufSize / __bytesPerSample);
        if (__format == 3) {
            __buf.asFloatBuffer().put((float[])lowerBuf);
        } else if (__format == 2) {
            __buf.asIntBuffer().put((int[])lowerBuf);
        } else if (__format == 1) {
            __buf.asShortBuffer().put((short[])lowerBuf);
        } else {
            __buf.put((byte[])lowerBuf);
        }
    }

    static native long __stream(long var0) throws MLECallError;
}

