/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.emulator.EmulatedBucketBracket;
import cc.squirreljme.jvm.mle.brackets.BucketBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.full.SystemPathProvider;
import cc.squirreljme.runtime.cldc.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class EmulatedBucketShelf {
    private static final Map<Integer, EmulatedBucketBracket> _buckets = new HashMap<Integer, EmulatedBucketBracket>();

    @SquirrelJMEVendorApi
    public static boolean delete(@NotNull BucketBracket __bucket, @NotNull String __file) throws MLECallError {
        if (__bucket == null || __file == null) {
            throw new MLECallError("NARG");
        }
        Path target = ((EmulatedBucketBracket)__bucket).__resolve(__file);
        try {
            return Files.deleteIfExists(target);
        }
        catch (IOException __e) {
            throw new MLECallError(__e.getMessage(), __e);
        }
    }

    @SquirrelJMEVendorApi
    public static long lastModifiedTime(@NotNull BucketBracket __bucket, @NotNull String __file) throws MLECallError {
        if (__bucket == null || __file == null) {
            throw new MLECallError("NARG");
        }
        Path target = ((EmulatedBucketBracket)__bucket).__resolve(__file);
        try {
            return Files.getLastModifiedTime(target, new LinkOption[0]).toMillis();
        }
        catch (IOException __e) {
            throw new MLECallError(__e.getMessage(), __e);
        }
    }

    @SquirrelJMEVendorApi
    public static boolean exists(@NotNull BucketBracket __bucket, @NotNull String __file) throws MLECallError {
        if (__bucket == null || __file == null) {
            throw new MLECallError("NARG");
        }
        Path path = ((EmulatedBucketBracket)__bucket).__resolve(__file);
        return Files.exists(path, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SquirrelJMEVendorApi
    public static BucketBracket bucket(int __type) throws MLECallError {
        Map<Integer, EmulatedBucketBracket> buckets = _buckets;
        Integer type = __type;
        Class<EmulatedBucketShelf> clazz = EmulatedBucketShelf.class;
        synchronized (EmulatedBucketShelf.class) {
            EmulatedBucketBracket result;
            if (buckets.containsKey(type)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return buckets.get(type);
            }
            if (__type == 0) {
                result = new EmulatedBucketBracket(SystemPathProvider.provider().state().resolve("data"));
            } else if (__type == 1) {
                result = new EmulatedBucketBracket(SystemPathProvider.provider().data().resolve("lib"));
            } else {
                throw new MLECallError("Unknown bucket type: " + __type);
            }
            buckets.put(type, result);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    @SquirrelJMEVendorApi
    public static String[] list(@NotNull BucketBracket __bucket) throws MLECallError {
        return EmulatedBucketShelf.list(__bucket, false, null, null, null);
    }

    @SquirrelJMEVendorApi
    public static String[] list(@NotNull BucketBracket __bucket, boolean __not, @Nullable String __prefix, @Nullable String __contains, @Nullable String __suffix) throws MLECallError {
        if (__bucket == null) {
            throw new MLECallError("NARG");
        }
        Path root = ((EmulatedBucketBracket)__bucket).root;
        int matching = (__prefix != null ? 1 : 0) | (__contains != null ? 2 : 0) | (__suffix != null ? 4 : 0);
        ArrayList<String> result = new ArrayList<String>();
        try (Stream stream2 = Files.list((Path)root);){
            for (Path path : (Path[])stream2.toArray(Path[]::new)) {
                if (!Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) continue;
                String baseName = path.getFileName().toString();
                if (matching != 0) {
                    int found = (__prefix != null && baseName.startsWith(__prefix)) | (__contains != null && baseName.contains(__contains) ? 2 : 0) | (__suffix != null && baseName.endsWith(__suffix) ? 4 : 0);
                    if ((found & matching) == matching == __not) continue;
                    result.add(baseName);
                    continue;
                }
                result.add(baseName);
            }
        }
        catch (FileNotFoundException | NoSuchFileException stream2) {
        }
        catch (IOException __e) {
            throw new MLECallError(__e.getMessage(), __e);
        }
        return result.toArray(new String[result.size()]);
    }

    @SquirrelJMEVendorApi
    public static long length(@NotNull BucketBracket __bucket, @NotNull String __file) throws MLECallError {
        if (__bucket == null || __file == null) {
            throw new MLECallError("NARG");
        }
        Path path = ((EmulatedBucketBracket)__bucket).__resolve(__file);
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return -1L;
            }
            return Files.size(path);
        }
        catch (FileNotFoundException __e) {
            return -1L;
        }
        catch (IOException __e) {
            throw new MLECallError(__e.getMessage(), __e);
        }
    }

    @SquirrelJMEVendorApi
    @NotNull
    public static String path(@NotNull BucketBracket __bucket) throws MLECallError {
        if (__bucket == null) {
            throw new MLECallError("No bucket specified.");
        }
        return ((EmulatedBucketBracket)__bucket).root.normalize().toAbsolutePath().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SquirrelJMEVendorApi
    public static int read(@NotNull BucketBracket __bucket, @NotNull String __file, @Range(from=0L, to=0x7FFFFFFFL) int __fileOff, @NotNull byte[] __buf, @Range(from=0L, to=0x7FFFFFFFL) int __off, @Range(from=0L, to=0x7FFFFFFFL) int __len) throws MLECallError {
        if (__bucket == null) throw new MLECallError("NARG");
        if (__file == null) throw new MLECallError("NARG");
        if (__buf == null) {
            throw new MLECallError("NARG");
        }
        if (__fileOff < 0) throw new MLECallError("IOOB");
        if (__off < 0) throw new MLECallError("IOOB");
        if (__len < 0) throw new MLECallError("IOOB");
        if (__off + __len < 0) throw new MLECallError("IOOB");
        if (__off + __len > __buf.length) {
            throw new MLECallError("IOOB");
        }
        Path path = ((EmulatedBucketBracket)__bucket).__resolve(__file);
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            int n2 = channel.read(ByteBuffer.wrap(__buf, __off, __len), __fileOff);
            return n2;
        }
        catch (IOException __e) {
            throw new MLECallError(__e.getMessage(), __e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SquirrelJMEVendorApi
    public static void write(@NotNull BucketBracket __bucket, @NotNull String __file, @Range(from=0L, to=0x7FFFFFFFL) int __fileOff, @NotNull byte[] __buf, @Range(from=0L, to=0x7FFFFFFFL) int __off, @Range(from=0L, to=0x7FFFFFFFL) int __len, int __mode) throws MLECallError {
        if (__bucket == null) throw new MLECallError("NARG");
        if (__file == null) throw new MLECallError("NARG");
        if (__buf == null) {
            throw new MLECallError("NARG");
        }
        if (__fileOff < 0) throw new MLECallError("IOOB");
        if (__off < 0) throw new MLECallError("IOOB");
        if (__len < 0) throw new MLECallError("IOOB");
        if (__off + __len < 0) {
            throw new MLECallError("IOOB");
        }
        Path target = ((EmulatedBucketBracket)__bucket).__resolve(__file);
        Path tempFile = null;
        try {
            try (ByteArrayInputStream in2 = new ByteArrayInputStream(__buf, __off, __len);){
                tempFile = Files.createTempFile("squirreljme", ".rms", new FileAttribute[0]);
                switch (__mode) {
                    case 1: {
                        if (__fileOff != 0) {
                            throw new MLECallError("File offset must be zero.");
                        }
                        Files.write((Path)tempFile, (byte[])StreamUtils.readAll(in2), (OpenOption[])new OpenOption[0]);
                        break;
                    }
                    default: {
                        throw Debugging.todo(__mode);
                    }
                }
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.move(tempFile, target, StandardCopyOption.REPLACE_EXISTING);
            }
            if (tempFile == null) return;
        }
        catch (IOException __e) {
            try {
                throw new MLECallError(__e.getMessage(), __e);
            }
            catch (Throwable throwable) {
                if (tempFile == null) throw throwable;
                try {
                    Files.deleteIfExists(tempFile);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Files.deleteIfExists(tempFile);
            return;
        }
        catch (IOException in2) {
            return;
        }
    }
}

