/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.emulator.EmulatedJarPackageBracket;
import cc.squirreljme.jvm.manifest.JavaManifest;
import cc.squirreljme.jvm.mle.JarPackageShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.mle.brackets.PipeBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.vm.DataContainerLibrary;
import cc.squirreljme.vm.JarClassLibrary;
import cc.squirreljme.vm.RawVMClassLibrary;
import cc.squirreljme.vm.VMClassLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class EmulatedJarPackageShelf {
    private static JarPackageBracket[] _CLASSPATH_CACHE;
    private static JarPackageBracket[] _LIB_CACHE;

    public static JarPackageBracket[] classPath() {
        JarPackageBracket[] rv = _CLASSPATH_CACHE;
        if (rv != null) {
            return (JarPackageBracket[])rv.clone();
        }
        String paths = System.getProperty("squirreljme.hosted.classpath");
        rv = paths != null ? EmulatedJarPackageShelf.__loadPaths(paths) : new JarPackageBracket[]{};
        _CLASSPATH_CACHE = rv;
        return (JarPackageBracket[])rv.clone();
    }

    public static boolean equals(JarPackageBracket __a, JarPackageBracket __b) {
        if (__a == __b) {
            return true;
        }
        if (!(__a instanceof EmulatedJarPackageBracket) || !(__b instanceof EmulatedJarPackageBracket)) {
            return false;
        }
        return Objects.equals(((EmulatedJarPackageBracket)__a).vmLib.name(), ((EmulatedJarPackageBracket)__b).vmLib.name());
    }

    public static JarPackageBracket[] libraries() {
        JarPackageBracket[] rv = _LIB_CACHE;
        if (rv != null) {
            return (JarPackageBracket[])rv.clone();
        }
        String paths = System.getProperty("squirreljme.hosted.libraries");
        rv = paths != null ? EmulatedJarPackageShelf.__loadPaths(paths) : new JarPackageBracket[]{};
        _LIB_CACHE = rv;
        return (JarPackageBracket[])rv.clone();
    }

    @SquirrelJMEVendorApi
    public static int libraryId(@NotNull JarPackageBracket __jar) throws MLECallError {
        if (__jar == null) {
            throw new MLECallError("No JAR.");
        }
        EmulatedJarPackageBracket jar = (EmulatedJarPackageBracket)__jar;
        Path path = jar.vmLib.path();
        return path != null ? path.hashCode() : jar.vmLib.name().hashCode();
    }

    public static String libraryPath(JarPackageBracket __jar) throws MLECallError {
        if (__jar == null) {
            throw new MLECallError("No JAR.");
        }
        Path path = ((EmulatedJarPackageBracket)__jar).vmLib.path();
        return Objects.toString(path, null);
    }

    public static PipeBracket openResourcePipe(JarPackageBracket __jar, String __rc) throws MLECallError {
        if (__jar == null || __rc == null) {
            throw new MLECallError("No JAR or resource.");
        }
        return ((EmulatedJarPackageBracket)__jar).openResource(__rc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int prefixCode(JarPackageBracket __jar) throws MLECallError {
        if (__jar == null) {
            throw new MLECallError("Null Jar");
        }
        try (InputStream in = JarPackageShelf.openResource(__jar, "META-INF/MANIFEST.MF");){
            if (in == null) {
                int n2 = -1;
                return n2;
            }
            JavaManifest manifest = new JavaManifest(in);
            String value = manifest.getMainAttributes().getValue("X-SquirrelJME-PrefixCode");
            if (value == null) {
                int n3 = -1;
                return n3;
            }
            char a2 = value.charAt(0);
            char b2 = value.charAt(1);
            int n4 = Character.digit(a2, 36) * 36 + Character.digit(b2, 36);
            return n4;
        }
        catch (IOException ignored) {
            return -1;
        }
    }

    private static JarPackageBracket[] __loadPaths(String __paths) {
        ArrayList<EmulatedJarPackageBracket> fill = new ArrayList<EmulatedJarPackageBracket>();
        int at2 = 0;
        while (true) {
            int next;
            String segment = (next = __paths.indexOf(File.pathSeparatorChar, at2 + 1)) < 0 ? __paths.substring(at2) : __paths.substring(at2, next);
            Path segPath = Paths.get(segment, new String[0]);
            RawVMClassLibrary vmLib = JarClassLibrary.isJar(segment) ? new JarClassLibrary(segPath) : new DataContainerLibrary(segPath);
            Debugging.debugNote("Registered %s as a %s.%n", segPath, vmLib.getClass().getName());
            fill.add(new EmulatedJarPackageBracket(vmLib));
            if (next < 0) break;
            at2 = next + 1;
        }
        return fill.toArray(new JarPackageBracket[fill.size()]);
    }

    public static int rawData(JarPackageBracket __jar, int __jarOffset, byte[] __b, int __o, int __l) throws MLECallError {
        if (__jar == null || __jarOffset < 0 || __b == null || __o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new MLECallError("Invalid parameters.");
        }
        EmulatedJarPackageBracket emul = (EmulatedJarPackageBracket)__jar;
        VMClassLibrary vmLib = emul.vmLib;
        if (!(vmLib instanceof RawVMClassLibrary)) {
            throw new MLECallError("JAR is not physically backed.");
        }
        RawVMClassLibrary rawLib = (RawVMClassLibrary)vmLib;
        rawLib.rawData(__jarOffset, __b, __o, __l);
        return __l;
    }

    public static int rawSize(JarPackageBracket __jar) throws MLECallError {
        if (__jar == null) {
            throw new MLECallError("No JAR specified.");
        }
        EmulatedJarPackageBracket emul = (EmulatedJarPackageBracket)__jar;
        Path path = emul.vmLib.path();
        VMClassLibrary vmLib = emul.vmLib;
        if (!(vmLib instanceof RawVMClassLibrary)) {
            throw new MLECallError("JAR is not physically backed.");
        }
        RawVMClassLibrary rawLib = (RawVMClassLibrary)vmLib;
        return rawLib.rawSize();
    }
}

