/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.emulator.BasicMidiMessage;
import cc.squirreljme.emulator.EmulatedMidiDeviceBracket;
import cc.squirreljme.emulator.EmulatedMidiPortBracket;
import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.jvm.mle.brackets.MidiDeviceBracket;
import cc.squirreljme.jvm.mle.brackets.MidiPortBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class EmulatedMidiShelf {
    private static volatile MidiDeviceBracket[] _DEVICES;

    public static int dataReceive(MidiPortBracket __port, byte[] __b, int __o, int __l) throws MLECallError {
        if (__port == null || __b == null || __o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new MLECallError("Invalid arguments.");
        }
        EmulatedMidiPortBracket emul = (EmulatedMidiPortBracket)__port;
        if (emul._transmitter == null) {
            throw new MLECallError("Not a MIDI receiver.");
        }
        Debugging.todoNote("Implement MIDI receive?");
        return 0;
    }

    public static void dataTransmit(MidiPortBracket __port, byte[] __b, int __o, int __l) throws MLECallError {
        if (__port == null || __b == null || __o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new MLECallError("Invalid arguments.");
        }
        EmulatedMidiPortBracket emul = (EmulatedMidiPortBracket)__port;
        if (emul._receiver == null) {
            throw new MLECallError("Not a MIDI transmitter.");
        }
        byte[] data = new byte[__l];
        ObjectShelf.arrayCopy(__b, __o, data, 0, __l);
        emul._receiver.send(new BasicMidiMessage(data), -1L);
    }

    public static String deviceName(MidiDeviceBracket __device) throws MLECallError {
        if (__device == null) {
            throw new MLECallError("Null argument.");
        }
        return ((EmulatedMidiDeviceBracket)__device)._info.getName();
    }

    public static MidiDeviceBracket[] devices() {
        MidiDeviceBracket[] devices = _DEVICES;
        if (devices != null) {
            return (MidiDeviceBracket[])devices.clone();
        }
        ArrayList<EmulatedMidiDeviceBracket> result = new ArrayList<EmulatedMidiDeviceBracket>();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                result.add(new EmulatedMidiDeviceBracket(MidiSystem.getMidiDevice(info), info));
            }
            catch (IllegalArgumentException | MidiUnavailableException exception) {
                // empty catch block
            }
        }
        _DEVICES = devices = (MidiDeviceBracket[])result.toArray(new EmulatedMidiDeviceBracket[result.size()]);
        return (MidiDeviceBracket[])devices.clone();
    }

    public static MidiPortBracket[] ports(MidiDeviceBracket __device, boolean __transmit) throws MLECallError {
        if (__device == null) {
            throw new MLECallError("Null argument.");
        }
        EmulatedMidiPortBracket result = null;
        EmulatedMidiDeviceBracket emul = (EmulatedMidiDeviceBracket)__device;
        if (!__transmit && emul._receivePorts != null) {
            return (MidiPortBracket[])emul._receivePorts.clone();
        }
        if (__transmit && emul._transmitPorts != null) {
            return (MidiPortBracket[])emul._transmitPorts.clone();
        }
        try {
            if (!emul._device.isOpen()) {
                emul._device.open();
            }
            if (!__transmit) {
                for (Transmitter transmitter : emul._device.getTransmitters()) {
                    result = new EmulatedMidiPortBracket(transmitter);
                }
                if (result == null) {
                    result = new EmulatedMidiPortBracket(emul._device.getTransmitter());
                }
                Debugging.debugNote("Found receiver: %s", result);
            } else {
                for (Receiver receiver : emul._device.getReceivers()) {
                    result = new EmulatedMidiPortBracket(receiver);
                }
                if (result == null) {
                    result = new EmulatedMidiPortBracket(emul._device.getReceiver());
                }
                Debugging.debugNote("Found transmitter: %s", result);
            }
        }
        catch (MidiUnavailableException e2) {
            e2.printStackTrace();
        }
        MidiPortBracket[] rv = result == null ? new MidiPortBracket[]{} : new MidiPortBracket[]{result};
        if (!__transmit && emul._transmitPorts != null) {
            emul._transmitPorts = (MidiPortBracket[])rv.clone();
        } else if (__transmit && emul._receivePorts != null) {
            emul._receivePorts = (MidiPortBracket[])rv.clone();
        }
        return rv;
    }
}

