/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.emulator.EmulatedNativeArchiveBracket;
import cc.squirreljme.emulator.EmulatedNativeArchiveEntryBracket;
import cc.squirreljme.emulator.EmulatedNativeZipArchiveBracket;
import cc.squirreljme.jvm.mle.brackets.NativeArchiveBracket;
import cc.squirreljme.jvm.mle.brackets.NativeArchiveEntryBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.IOException;
import java.io.InputStream;
import net.multiphasicapps.zip.blockreader.ZipBlockReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class EmulatedNativeArchiveShelf {
    private EmulatedNativeArchiveShelf() {
    }

    @SquirrelJMEVendorApi
    public static void archiveClose(@NotNull NativeArchiveBracket __archive) throws MLECallError {
        if (__archive == null) {
            throw new MLECallError("Null arguments.");
        }
        try {
            ((EmulatedNativeArchiveBracket)__archive).close();
        }
        catch (IOException __e) {
            throw new MLECallError("Could not close archive.", __e);
        }
    }

    @SquirrelJMEVendorApi
    @Nullable
    public static NativeArchiveEntryBracket archiveEntry(@NotNull NativeArchiveBracket __archive, @NotNull String __name) throws MLECallError {
        if (__archive == null || __name == null) {
            throw new MLECallError("Null arguments.");
        }
        return ((EmulatedNativeArchiveBracket)__archive).entry(__name);
    }

    @SquirrelJMEVendorApi
    @NotNull
    public static NativeArchiveBracket archiveOpenZip(@NotNull byte[] __buf, @Range(from=0L, to=0x7FFFFFFFL) int __off, @Range(from=0L, to=0x7FFFFFFFL) int __len) throws MLECallError {
        if (__buf == null) {
            throw new MLECallError("Null arguments.");
        }
        if (__off < 0 || __len < 0 || __off + __len < 0 || __off + __len > __buf.length) {
            throw new MLECallError("Buffer out of bounds.");
        }
        try {
            return new EmulatedNativeZipArchiveBracket(new ZipBlockReader(__buf, __off, __len));
        }
        catch (IOException __e) {
            throw new MLECallError("Could not initialize Zip.", __e);
        }
    }

    public static boolean entryIsDirectory(@NotNull NativeArchiveEntryBracket __entry) throws MLECallError {
        if (__entry == null) {
            throw new MLECallError("Null arguments.");
        }
        return ((EmulatedNativeArchiveEntryBracket)__entry).isDirectory();
    }

    public static InputStream entryOpen(@NotNull NativeArchiveEntryBracket __entry) throws MLECallError {
        if (__entry == null) {
            throw new MLECallError("Null arguments.");
        }
        return ((EmulatedNativeArchiveEntryBracket)__entry).open();
    }

    public static long entryUncompressedSize(@NotNull NativeArchiveEntryBracket __entry) throws MLECallError {
        if (__entry == null) {
            throw new MLECallError("Null arguments.");
        }
        return ((EmulatedNativeArchiveEntryBracket)__entry).uncompressedSize();
    }
}

