/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class EmulatedRuntimeShelf {
    public static void browseLocal(boolean __create, String __path) throws MLECallError {
        if (__path == null) {
            throw new MLECallError("No path specified.");
        }
        try {
            Path path = Paths.get(__path, new String[0]).normalize().toAbsolutePath();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                throw new MLECallError("Target not a directory: " + __path);
            }
            if (__create && !Files.isSymbolicLink((Path)path) && !Files.isDirectory(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("linux") || os.contains("bsd")) {
                    new ProcessBuilder("xdg-open", path.toString()).start();
                } else if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(path.toFile());
                }
            }
        }
        catch (IOException __e) {
            throw new MLECallError(__e.getMessage(), __e);
        }
    }

    public static String systemEnv(String __key) throws MLECallError {
        if (__key == null) {
            throw new MLECallError("No key specified.");
        }
        return System.getenv((String)__key);
    }

    public static String vmDescription(int __type) throws MLECallError {
        switch (__type) {
            case 0: {
                return null;
            }
            case 1: {
                return System.getProperty("java.vm.version");
            }
            case 2: {
                return System.getProperty("java.vm.name");
            }
            case 3: {
                return System.getProperty("java.vm.vendor");
            }
            case 4: {
                return System.getProperty("java.vm.vendor.email");
            }
            case 5: {
                return System.getProperty("java.vm.vendor.url");
            }
            case 6: {
                return null;
            }
            case 7: {
                return System.getProperty("os.name");
            }
            case 8: {
                return System.getProperty("os.version");
            }
            case 9: {
                return System.getProperty("os.arch");
            }
            case 10: {
                return null;
            }
            case 13: {
                return System.getProperty("file.separator");
            }
            case 14: {
                return System.getProperty("java.vm.info");
            }
        }
        throw new MLECallError("Invalid " + __type);
    }

    public static long vmStatistic(int __type) throws MLECallError {
        if (__type < 0 || __type >= 5) {
            throw new MLECallError("Bad statistic: " + __type);
        }
        switch (__type) {
            case 4: {
                return Runtime.getRuntime().availableProcessors();
            }
            case 1: {
                return Runtime.getRuntime().freeMemory();
            }
            case 2: {
                return Runtime.getRuntime().maxMemory();
            }
            case 3: {
                return Runtime.getRuntime().totalMemory();
            }
        }
        return 0L;
    }
}

