/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.emulator.EmulatedJarPackageBracket;
import cc.squirreljme.emulator.EmulatedTaskBracket;
import cc.squirreljme.emulator.NativeBinding;
import cc.squirreljme.emulator.ProcessKiller;
import cc.squirreljme.jvm.mle.RuntimeShelf;
import cc.squirreljme.jvm.mle.brackets.JarPackageBracket;
import cc.squirreljme.jvm.mle.brackets.TaskBracket;
import cc.squirreljme.jvm.mle.exceptions.MLECallError;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class EmulatedTaskShelf {
    public static final String AVAILABLE_LIBRARIES = "squirreljme.hosted.libraries";
    public static final String RUN_CLASSPATH = "squirreljme.hosted.classpath";
    public static final String HOSTED_VM_CLASSPATH = "squirreljme.hosted.vm.classpath";
    public static final String HOSTED_VM_SUPPORTPATH = "squirreljme.hosted.vm.supportpath";
    public static final String ORIGINAL_PROP_PREFIX = "squirreljme.orig.";
    private static final boolean _ON_WINDOWS;

    public static String classpathAsString(Path ... __paths) throws NullPointerException {
        if (__paths == null) {
            throw new NullPointerException("NARG");
        }
        return EmulatedTaskShelf.classpathAsString(Arrays.asList(__paths));
    }

    public static String classpathAsString(Iterable<Path> __paths) throws NullPointerException {
        if (__paths == null) {
            throw new NullPointerException("NARG");
        }
        StringBuilder sb = new StringBuilder();
        for (Path path : __paths) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        return sb.toString();
    }

    public static TaskBracket start(JarPackageBracket[] __classPath, String __mainClass, String[] __args, String[] __sysPropPairs, int __stdOut, int __stdErr) throws MLECallError {
        Path emulatorLib;
        if (__classPath == null || __mainClass == null || __args == null || __sysPropPairs == null) {
            throw new MLECallError("Null start() arguments.");
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        LinkedList<String> args = new LinkedList<String>();
        args.add(Objects.toString(RuntimeShelf.vmDescription(6), "java"));
        LinkedHashMap<String, String> sysProps = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> e2 : System.getProperties().entrySet()) {
            String key = e2.getKey().toString();
            if (key.startsWith(ORIGINAL_PROP_PREFIX)) {
                sysProps.put(key.substring(ORIGINAL_PROP_PREFIX.length()), Objects.toString(e2.getValue(), ""));
                sysProps.put(key, Objects.toString(e2.getValue(), ""));
                continue;
            }
            switch (key) {
                case "squirreljme.hosted.libraries": 
                case "squirreljme.hosted.classpath": 
                case "squirreljme.hosted.vm.classpath": 
                case "squirreljme.hosted.vm.supportpath": 
                case "squirreljme.emulator.libpath": {
                    sysProps.put(key, Objects.toString(e2.getValue(), ""));
                }
            }
        }
        String preloadLib = (String)sysProps.get("squirreljme.emulator.libpath");
        if ((preloadLib == null || preloadLib.isEmpty()) && (emulatorLib = NativeBinding.loadedLibraryPath()) != null) {
            sysProps.put("squirreljme.emulator.libpath", emulatorLib.toAbsolutePath().toString());
        }
        int n2 = __sysPropPairs.length & 0xFFFFFFFE;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            sysProps.put(__sysPropPairs[i2], __sysPropPairs[i2 + 1]);
        }
        Path[] vmSupportPath = EmulatedTaskShelf.__classpathDecode(System.getProperty(HOSTED_VM_SUPPORTPATH));
        Path[] runClassPath = new Path[__classPath.length];
        int n3 = __classPath.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            runClassPath[i3] = ((EmulatedJarPackageBracket)__classPath[i3]).vmLib.path();
        }
        sysProps.put(RUN_CLASSPATH, EmulatedTaskShelf.classpathAsString(runClassPath));
        LinkedHashSet<Path> allLibs = new LinkedHashSet<Path>();
        allLibs.addAll(Arrays.asList(vmSupportPath));
        allLibs.addAll(Arrays.asList(runClassPath));
        String allLibsStr = EmulatedTaskShelf.classpathAsString(allLibs);
        sysProps.put(HOSTED_VM_CLASSPATH, allLibsStr);
        args.add("-classpath");
        args.add(allLibsStr);
        for (Map.Entry e3 : sysProps.entrySet()) {
            args.add(EmulatedTaskShelf.__escape(String.format("-D%s=%s", e3.getKey(), e3.getValue())));
        }
        args.add("cc.squirreljme.emulator.NativeBinding");
        args.add(__mainClass);
        args.addAll(Arrays.asList(__args));
        builder.command(args);
        Debugging.debugNote("Forked CmdLine: %s", args);
        switch (__stdOut) {
            case 2: {
                builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                break;
            }
            case 0: 
            case 1: {
                throw Debugging.todo();
            }
            default: {
                throw new MLECallError("Unknown stdOut: " + __stdOut);
            }
        }
        switch (__stdErr) {
            case 2: {
                builder.redirectError(ProcessBuilder.Redirect.INHERIT);
                break;
            }
            case 0: 
            case 1: {
                throw Debugging.todo();
            }
            default: {
                throw new MLECallError("Unknown stdOut: " + __stdOut);
            }
        }
        try {
            Process process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new ProcessKiller(process), String.format("processKiller@%08x", System.identityHashCode(process))));
            return new EmulatedTaskBracket(process);
        }
        catch (IOException e4) {
            throw new MLECallError("Could not spawn task.", e4);
        }
    }

    public static int status(TaskBracket __task) throws MLECallError {
        if (__task == null) {
            throw new MLECallError("Null task.");
        }
        Process process = ((EmulatedTaskBracket)__task).process;
        if (process.isAlive()) {
            return 1;
        }
        return 0;
    }

    static Path[] __classpathDecode(String __string) throws NullPointerException {
        if (__string == null) {
            throw new NullPointerException("NARG");
        }
        LinkedList<Path> result = new LinkedList<Path>();
        for (String split : __string.split(Pattern.quote(File.pathSeparator))) {
            result.add(Paths.get(split, new String[0]));
        }
        return result.toArray(new Path[result.size()]);
    }

    static String __escape(String __s) {
        if (!_ON_WINDOWS) {
            return __s;
        }
        if (__s.indexOf(34) < 0) {
            return __s;
        }
        StringBuilder result = new StringBuilder();
        int n2 = __s.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = __s.charAt(i2);
            if (c2 == '\"') {
                result.append('\\');
            }
            result.append(c2);
        }
        return result.toString();
    }

    static {
        String osName = System.getProperty("os.name");
        _ON_WINDOWS = osName.toLowerCase().contains("windows");
    }
}

