/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.jvm.mle.ReflectionShelf;
import cc.squirreljme.jvm.mle.TypeShelf;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageIO;

public final class NativeBinding {
    public static final String LIB_PRELOAD = "squirreljme.emulator.libpath";
    private static volatile Path loadedLibPath;
    private static volatile Path tempLibPath;

    private static native int __bindMethods();

    /*
     * Exception decompiling
     */
    public static Path libFromResources(String __libBaseName, boolean __map) throws LinkageError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path loadedLibraryPath() {
        return loadedLibPath;
    }

    public static void main(String ... __args) throws Throwable {
        new NativeBinding();
        String targetMain = __args[0];
        String[] targetArgs = (String[])Arrays.copyOfRange((Object[])__args, (int)1, (int)__args.length);
        ReflectionShelf.invokeMain(TypeShelf.findType(targetMain), targetArgs);
    }

    public static String nativeOs() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT).replaceAll("[\\s<>:\"/\\\\|?*]", "");
        if (osName.contains("windows")) {
            return "windows";
        }
        if (osName.contains("mac os") || osName.contains("macos")) {
            return "macos";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("solaris")) {
            return "solaris";
        }
        if (osName.contains("bsd")) {
            return "bsd";
        }
        return osName;
    }

    public static String nativePrefix() {
        String osName = NativeBinding.nativeOs();
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT).replaceAll("[\\s<>:\"/\\\\|?*]", "");
        if (osArch.equalsIgnoreCase("arm64") || osArch.equalsIgnoreCase("arm64-v8") || osArch.equalsIgnoreCase("aarch64")) {
            osArch = "aarch64";
        }
        return "/natives/" + osName + "/" + osArch;
    }

    private static Path __checkPreload() {
        String libProp = System.getProperty(LIB_PRELOAD);
        if (libProp == null) {
            return null;
        }
        Path path = Paths.get(libProp, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        System.setProperty((String)"apple.laf.useScreenMenuBar", (String)"true");
        System.setProperty((String)"com.apple.mrj.application.apple.menu.about.name", (String)"SquirrelJME");
        try {
            Class<?> taskbarClass = Class.forName("java.awt.Taskbar");
            Method getTaskbarMethod = taskbarClass.getMethod("getTaskbar", new Class[0]);
            Object taskbar = getTaskbarMethod.invoke(null, new Object[0]);
            try (InputStream in = NativeBinding.class.getResourceAsStream("icon.png");){
                if (in != null) {
                    BufferedImage icon = ImageIO.read(in);
                    Method setIconImageMethod = taskbarClass.getMethod("setIconImage", new Class[]{Image.class});
                    setIconImageMethod.invoke(taskbar, icon);
                }
            }
        }
        catch (IOException | ReflectiveOperationException | SecurityException | UnsupportedOperationException taskbarClass) {
            // empty catch block
        }
        long loadNs = System.nanoTime();
        try {
            Path libFile = NativeBinding.__checkPreload();
            if (libFile == null) {
                libFile = NativeBinding.libFromResources("emulator-base", true);
            }
            loadedLibPath = libFile;
            if (Debugging.VERBOSE) {
                System.err.printf("Java Version: %s%n", System.getProperty("java.version"));
                System.err.printf("Java Over-Layer: Loading %s...%n", libFile);
            }
            System.load((String)libFile.toString());
            if (Debugging.VERBOSE) {
                System.err.printf("Java Over-Layer: Binding methods...%n", new Object[0]);
            }
            if (NativeBinding.__bindMethods() != 0) {
                throw new RuntimeException("Could not bind methods!");
            }
            if (Debugging.VERBOSE) {
                System.err.printf("Java Over-Layer: Methods bound!%n", new Object[0]);
            }
            if (!Debugging.VERBOSE) return;
        }
        catch (LinkageError e2) {
            try {
                throw new RuntimeException("Could not load library.", e2);
            }
            catch (Throwable throwable) {
                if (!Debugging.VERBOSE) throw throwable;
                System.err.printf("Java Over-Layer: Loading took %dms%n", (System.nanoTime() - loadNs) / 1000000L);
                throw throwable;
            }
        }
        System.err.printf("Java Over-Layer: Loading took %dms%n", (System.nanoTime() - loadNs) / 1000000L);
        return;
    }
}

