/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator;

import cc.squirreljme.jvm.mle.exceptions.MLECallError;

public final class NativeThreadShelf {
    private static final __ThreadCountTracker__ _TRACKER = new __ThreadCountTracker__();
    private static final int _TRACKER_WAIT = 250;
    static volatile int _currentCount = -1;

    private NativeThreadShelf() {
    }

    public static int aliveThreadCount(boolean __includeMain, boolean __includeDaemon) {
        int daemon = 0;
        int nonDaemon = 0;
        __ThreadCountTracker__ tracker = _TRACKER;
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread == tracker) continue;
            boolean isDaemon = thread.isDaemon();
            if (!__includeDaemon && isDaemon || !thread.isAlive()) continue;
            if (isDaemon) {
                ++daemon;
                continue;
            }
            ++nonDaemon;
        }
        return daemon + Math.max(0, nonDaemon - (__includeMain ? 0 : 1));
    }

    public static void javaThreadSetDaemon(Thread __thread) throws MLECallError {
        if (__thread == null) {
            throw new MLECallError("Null thread.");
        }
        try {
            __thread.setDaemon(true);
        }
        catch (IllegalThreadStateException ignored) {
            throw new MLECallError("Thread is alive.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForUpdate(int __ms) throws MLECallError {
        if (__ms < 0) {
            throw new MLECallError("Negative waitForUpdate() time");
        }
        long stopTime = System.nanoTime() + (long)__ms * 1000000L;
        Class<NativeThreadShelf> clazz = NativeThreadShelf.class;
        synchronized (NativeThreadShelf.class) {
            int lastCount = _currentCount;
            while (true) {
                if (lastCount != _currentCount) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return true;
                }
                long diffTime = stopTime - System.nanoTime();
                if (diffTime <= 0L) break;
                try {
                    NativeThreadShelf.class.wait(diffTime / 1000000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return false;
        }
    }

    static {
        _TRACKER.start();
    }

    private static final class __ThreadCountTracker__
    extends Thread {
        __ThreadCountTracker__() {
            super("SquirrelJME-ThreadCountTracker");
            super.setDaemon(true);
        }

        @Override
        public void run() {
            Class<NativeThreadShelf> clazz = NativeThreadShelf.class;
            synchronized (NativeThreadShelf.class) {
                int lastCount = _currentCount;
                while (true) {
                    int currentCount;
                    _currentCount = currentCount = Thread.activeCount();
                    if (lastCount != currentCount) {
                        NativeThreadShelf.class.notifyAll();
                        lastCount = currentCount;
                    }
                    try {
                        NativeThreadShelf.class.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

