/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.profiler;

import cc.squirreljme.emulator.profiler.FrameLocation;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ProfiledFrame {
    public static final int MAX_STACK_DEPTH = 64;
    protected final FrameLocation location;
    final int _depth;
    final Map<FrameLocation, ProfiledFrame> _frames = new LinkedHashMap<FrameLocation, ProfiledFrame>();
    int _numCalls;
    long _totalTime;
    long _totalCpuTime;
    long _selfTime;
    long _selfCpuTime;
    private long _invokingTime;
    long _sleepTime;
    private long _currentstart = Long.MIN_VALUE;
    private long _currentsubstart = Long.MIN_VALUE;
    private long _sleepStart = Long.MIN_VALUE;
    private int _inCallCount;

    public ProfiledFrame(FrameLocation __l, int __d) throws NullPointerException {
        if (__l == null) {
            throw new NullPointerException("NARG");
        }
        this.location = __l;
        this._depth = __d;
    }

    public final void enteredFrame(long __ns) throws IllegalStateException {
        long cs2 = this._currentstart;
        if (cs2 != Long.MIN_VALUE) {
            throw new IllegalStateException("AH01");
        }
        if (this._currentsubstart != Long.MIN_VALUE) {
            throw new IllegalStateException("AH02");
        }
        this._currentstart = __ns;
        ++this._inCallCount;
        ++this._numCalls;
    }

    public final long[] exitedFrame(long __ns) throws IllegalStateException {
        long cs2 = this._currentstart;
        if (cs2 == Long.MIN_VALUE) {
            throw new IllegalStateException("AH03");
        }
        if (this._currentsubstart != Long.MIN_VALUE) {
            throw new IllegalStateException("AH04");
        }
        long total = __ns - cs2;
        long self = total - this._invokingTime;
        long sleepTime = this._sleepTime;
        long selfCPU = self - sleepTime;
        this._totalTime += self;
        this._totalCpuTime += selfCPU;
        this._selfTime += self;
        this._selfCpuTime += selfCPU;
        this._currentstart = Long.MIN_VALUE;
        this._invokingTime = 0L;
        this._sleepTime = 0L;
        if (--this._inCallCount < 0) {
            this._inCallCount = 0;
        }
        return new long[]{total, self, selfCPU, sleepTime};
    }

    public final int inCallCount() {
        return this._inCallCount;
    }

    public final long invokeEnd(long __ns) throws IllegalStateException {
        long css = this._currentsubstart;
        if (css == Long.MIN_VALUE) {
            throw new IllegalStateException("AH05");
        }
        this._currentsubstart = Long.MIN_VALUE;
        long rv = Math.max(0L, __ns - css);
        this._invokingTime += rv;
        return rv;
    }

    public final void invokeStart(long __ns) throws IllegalStateException {
        long css = this._currentsubstart;
        if (css != Long.MIN_VALUE) {
            throw new IllegalStateException("AH06");
        }
        this._currentsubstart = __ns;
    }

    public void sleep(boolean __enter, long __ns) {
        long sleepStart = this._sleepStart;
        if (__enter) {
            if (sleepStart != Long.MIN_VALUE) {
                throw new IllegalStateException("Frame is already sleeping.");
            }
            this._sleepStart = __ns;
        } else {
            if (sleepStart == Long.MIN_VALUE) {
                throw new IllegalStateException("Frame is not asleep.");
            }
            this._sleepStart = Long.MIN_VALUE;
            this._sleepTime += Math.max(0L, __ns - sleepStart);
        }
    }
}

