/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.profiler;

import cc.squirreljme.emulator.profiler.FrameLocation;
import cc.squirreljme.emulator.profiler.ProfiledFrame;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class ProfiledThread {
    protected final String name;
    final Map<FrameLocation, ProfiledFrame> _frames = new LinkedHashMap<FrameLocation, ProfiledFrame>();
    private final Deque<ProfiledFrame> _stack = new LinkedList<ProfiledFrame>();
    long _invtotal;
    long _totalTime;
    long _cpuTime;

    public ProfiledThread(String __n) throws NullPointerException {
        if (__n == null) {
            throw new NullPointerException("NARG");
        }
        this.name = __n;
    }

    public ProfiledFrame enterFrame(String __cl, String __mn, String __md) throws NullPointerException {
        return this.enterFrame(__cl, __mn, __md, System.nanoTime());
    }

    public ProfiledFrame enterFrame(String __cl, String __mn, String __md, long __ns) throws NullPointerException {
        if (__cl == null || __mn == null || __md == null) {
            throw new NullPointerException("NARG");
        }
        FrameLocation loc = new FrameLocation(__cl, __mn, __md);
        Deque<ProfiledFrame> stack = this._stack;
        ProfiledFrame top = stack.peek();
        Map<FrameLocation, ProfiledFrame> frames = top == null ? this._frames : top._frames;
        ProfiledFrame rv = frames.get(loc);
        if (rv == null) {
            rv = new ProfiledFrame(loc, stack.size() + 1);
            frames.put(loc, rv);
        }
        if (top != null) {
            top.invokeStart(__ns);
        }
        this._stack.push(rv);
        rv.enteredFrame(__ns);
        return rv;
    }

    public void exitAll() {
        this.exitAll(System.nanoTime());
    }

    public void exitAll(long __ns) {
        Deque<ProfiledFrame> stack = this._stack;
        while (!stack.isEmpty()) {
            this.exitFrame(__ns);
        }
    }

    public ProfiledFrame exitFrame() throws IllegalStateException {
        return this.exitFrame(System.nanoTime());
    }

    public ProfiledFrame exitFrame(long __ns) throws IllegalStateException {
        Deque<ProfiledFrame> stack = this._stack;
        ProfiledFrame rv = stack.pop();
        if (rv == null) {
            throw new IllegalStateException("AH07");
        }
        long[] times = rv.exitedFrame(__ns);
        this._totalTime += Math.max(0L, times[1]);
        this._cpuTime += Math.max(0L, times[2]);
        for (ProfiledFrame frame : stack) {
            frame._totalTime += Math.max(0L, times[1]);
            frame._totalCpuTime += Math.max(0L, times[2]);
        }
        ProfiledFrame newTop = stack.peek();
        if (newTop != null) {
            newTop.invokeEnd(__ns);
        } else {
            ++this._invtotal;
        }
        return rv;
    }
}

