/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.profiler;

import cc.squirreljme.emulator.profiler.FrameLocation;
import cc.squirreljme.emulator.profiler.ProfiledFrame;
import cc.squirreljme.emulator.profiler.ProfiledThread;
import cc.squirreljme.emulator.profiler.__NodeTable__;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.multiphasicapps.io.ZLibCompressor;

public final class ProfilerSnapshot {
    protected final long startmillis = System.currentTimeMillis();
    private final Map<String, ProfiledThread> _threads = new LinkedHashMap<String, ProfiledThread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProfiledThread measureThread(String __name) throws NullPointerException {
        Map<String, ProfiledThread> threads;
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        ProfiledThread rv = new ProfiledThread(__name);
        Map<String, ProfiledThread> map = threads = this._threads;
        synchronized (map) {
            threads.put(__name, rv);
        }
        return rv;
    }

    public final void exitAll() {
        this.exitAll(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitAll(long __ns) {
        Map<String, ProfiledThread> threads;
        Map<String, ProfiledThread> map = threads = this._threads;
        synchronized (map) {
            for (ProfiledThread thread : threads.values()) {
                thread.exitAll(__ns);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDumpTo(PrintStream __ps) throws NullPointerException {
        Map<String, ProfiledThread> threads;
        if (__ps == null) {
            throw new NullPointerException("NARG");
        }
        __ps.println("Profiler snapshot:");
        Map<String, ProfiledThread> map = threads = this._threads;
        synchronized (map) {
            for (ProfiledThread t2 : threads.values()) {
                __ps.print("  Thread ");
                __ps.print(t2.name);
                __ps.println(':');
                ProfilerSnapshot.__dumpFrames(__ps, 4, t2._frames.values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(OutputStream __os) throws IOException, NullPointerException {
        if (__os == null) {
            throw new NullPointerException("NARG");
        }
        DataOutputStream cont = new DataOutputStream(__os);
        cont.writeBytes("nBpRoFiLeR");
        cont.write(1);
        cont.write(2);
        cont.writeInt(1);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);){
            ZLibCompressor olddefl;
            try (ZLibCompressor defl = new ZLibCompressor(baos);
                 DataOutputStream cpu = new DataOutputStream(defl);){
                Map<String, ProfiledThread> threads;
                olddefl = defl;
                cpu.writeInt(1);
                cpu.writeLong(this.startmillis);
                Map<String, ProfiledThread> map = threads = this._threads;
                synchronized (map) {
                    long maxtime = 0L;
                    for (ProfiledThread t2 : threads.values()) {
                        maxtime = Math.max(maxtime, t2._totalTime);
                    }
                    cpu.writeLong(maxtime);
                    cpu.writeBoolean(true);
                    Map<FrameLocation, Integer> mids = this.__doMethodTable();
                    cpu.writeInt(mids.size());
                    for (FrameLocation loc : mids.keySet()) {
                        cpu.writeUTF(loc.inclass);
                        cpu.writeUTF(loc.methodname);
                        cpu.writeUTF(loc.methodtype);
                    }
                    cpu.writeInt(threads.size());
                    for (ProfiledThread t3 : threads.values()) {
                        this.__doWriteThread(cpu, t3, mids);
                    }
                }
            }
            cont.writeInt(baos.size());
            cont.writeInt((int)Math.min(Integer.MAX_VALUE, olddefl.uncompressedBytes()));
            baos.writeTo(cont);
        }
        baos = new ByteArrayOutputStream(2048);
        var4_4 = null;
        try {
            try (PrintStream ps = new PrintStream(baos, true);){
                ps.flush();
            }
            cont.writeInt(baos.size());
            baos.writeTo(cont);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (baos != null) {
                if (var4_4 != null) {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    baos.close();
                }
            }
        }
        cont.writeUTF("Generated by SquirrelJME <https://multiphasicapps.net/>\nCopyright (C) Stephanie Gawroriski 2016-2019\n\nRecord date: " + new Date());
        cont.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FrameLocation, Integer> __doMethodTable() {
        Map<String, ProfiledThread> threads;
        LinkedHashMap<FrameLocation, Integer> rv = new LinkedHashMap<FrameLocation, Integer>();
        int[] next = new int[1];
        int n2 = next[0];
        next[0] = n2 + 1;
        rv.put(FrameLocation.ENTRY_POINT, n2);
        Map<String, ProfiledThread> map = threads = this._threads;
        synchronized (map) {
            for (ProfiledThread t2 : threads.values()) {
                this.__doMethodTableSub(rv, next, t2._frames.values());
            }
        }
        return rv;
    }

    private Map<FrameLocation, Integer> __doMethodTableSub(Map<FrameLocation, Integer> __rv, int[] __nid, Iterable<ProfiledFrame> __fs) throws NullPointerException {
        if (__rv == null || __nid == null || __fs == null) {
            throw new NullPointerException("NARG");
        }
        for (ProfiledFrame f2 : __fs) {
            if (f2._depth >= 64) continue;
            FrameLocation loc = f2.location;
            if (!__rv.containsKey(loc)) {
                int id;
                __nid[0] = __nid[0] + 1;
                __rv.put(loc, id);
            }
            this.__doMethodTableSub(__rv, __nid, f2._frames.values());
        }
        return __rv;
    }

    private void __doWriteThread(DataOutputStream __cpu, ProfiledThread __t, Map<FrameLocation, Integer> __mids) throws IOException, NullPointerException {
        if (__cpu == null || __t == null || __mids == null) {
            throw new NullPointerException("NARG");
        }
        __cpu.writeInt(__t.name.hashCode());
        __cpu.writeUTF(__t.name);
        __cpu.writeBoolean(true);
        __NodeTable__ nodes = new __NodeTable__();
        nodes.parseThread(__t);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);){
            nodes.writeTo(baos, __mids);
            __cpu.writeInt(baos.size());
            baos.writeTo(__cpu);
        }
        __cpu.writeInt(28);
        __cpu.writeLong(__t._totalTime);
        __cpu.writeLong(__t._cpuTime);
        __cpu.writeLong(0L);
        __cpu.writeLong(0L);
        __cpu.writeLong(Integer.MAX_VALUE);
        __cpu.writeLong(Integer.MAX_VALUE);
        __cpu.writeLong(__t._totalTime);
        __cpu.writeLong(__t._cpuTime);
        __cpu.writeLong(__t._invtotal);
        __cpu.writeBoolean(true);
    }

    private static void __dumpFrames(PrintStream __ps, int __tab, Iterable<ProfiledFrame> __fs) throws NullPointerException {
        if (__ps == null || __fs == null) {
            throw new NullPointerException("NARG");
        }
        for (ProfiledFrame f2 : __fs) {
            for (int i2 = 0; i2 < __tab; ++i2) {
                __ps.print(' ');
            }
            __ps.print(f2.location);
            __ps.printf(" [n=%d, t=%d, s=%d]", f2._numCalls, f2._totalTime, f2._selfTime);
            __ps.println();
            ProfilerSnapshot.__dumpFrames(__ps, __tab + 1, f2._frames.values());
        }
    }
}

