/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.profiler;

import cc.squirreljme.emulator.profiler.FrameLocation;
import cc.squirreljme.emulator.profiler.ProfiledFrame;
import cc.squirreljme.emulator.profiler.ProfiledThread;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class __NodeTable__ {
    private final List<ProfiledFrame> _linear = new ArrayList<ProfiledFrame>();
    private final Map<ProfiledFrame, __Position__> _offsets = new HashMap<ProfiledFrame, __Position__>();
    private final __Position__ _at = new __Position__();
    private boolean _overflowed;

    __NodeTable__() {
    }

    public final void parse(Iterable<ProfiledFrame> __fs) throws NullPointerException {
        if (__fs == null) {
            throw new NullPointerException("NARG");
        }
        List<ProfiledFrame> linear = this._linear;
        Map<ProfiledFrame, __Position__> offsets = this._offsets;
        boolean overflowed = false;
        __Position__ at2 = this._at;
        for (ProfiledFrame f2 : __fs) {
            if (f2._depth >= 64) continue;
            Collection<ProfiledFrame> sub = f2._frames.values();
            linear.add(f2);
            offsets.put(f2, at2.increment(sub.size()));
            this.parse(sub);
            if (at2._narrow <= 0xFFFFFF) continue;
            overflowed = true;
        }
        if (overflowed) {
            this._overflowed = true;
        }
    }

    public final void parseThread(ProfiledThread __t) throws NullPointerException {
        if (__t == null) {
            throw new NullPointerException("NARG");
        }
        Collection<ProfiledFrame> frames = __t._frames.values();
        ProfiledFrame vframe = new ProfiledFrame(FrameLocation.ENTRY_POINT, 0);
        vframe._numCalls = 1;
        vframe._totalTime = __t._totalTime;
        vframe._totalCpuTime = __t._cpuTime;
        vframe._selfTime = __t._totalTime;
        vframe._selfCpuTime = __t._cpuTime;
        Map<FrameLocation, ProfiledFrame> vsubf = vframe._frames;
        for (ProfiledFrame f2 : frames) {
            vsubf.put(f2.location, f2);
        }
        this.parse(Arrays.asList(vframe));
    }

    public final void writeTo(OutputStream __os, Map<FrameLocation, Integer> __mids) throws IOException, NullPointerException {
        if (__os == null || __mids == null) {
            throw new NullPointerException("NARG");
        }
        DataOutputStream dos = new DataOutputStream(__os);
        List<ProfiledFrame> linear = this._linear;
        boolean wide = this._overflowed;
        Map<ProfiledFrame, __Position__> offsets = this._offsets;
        for (ProfiledFrame f2 : linear) {
            FrameLocation location = f2.location;
            Integer flid = __mids.get(f2.location);
            if (f2._depth >= 64 || flid == null) continue;
            dos.writeShort(flid);
            dos.writeInt(Math.max(1, f2._numCalls));
            __NodeTable__.__writeLong40(dos, f2._totalTime);
            __NodeTable__.__writeLong40(dos, f2._selfTime);
            __NodeTable__.__writeLong40(dos, f2._totalCpuTime);
            __NodeTable__.__writeLong40(dos, f2._selfCpuTime);
            Collection<ProfiledFrame> sub = f2._frames.values();
            int actsubs = 0;
            for (ProfiledFrame sf : sub) {
                if (sf._depth >= 64) continue;
                ++actsubs;
            }
            dos.writeShort(actsubs);
            for (ProfiledFrame sf : sub) {
                if (sf._depth >= 64) continue;
                __Position__ p2 = offsets.get(sf);
                if (wide) {
                    dos.writeInt(p2._wide);
                    continue;
                }
                __NodeTable__.__writeInt24(dos, p2._narrow);
            }
        }
    }

    static final void __writeInt24(DataOutputStream __dos, int __v) throws IOException {
        if (__v < 0) {
            __v = 0;
        } else if (__v > 0xFFFFFF) {
            __v = 0xFFFFFF;
        }
        __dos.writeByte((byte)(__v >>> 16));
        __dos.writeByte((byte)(__v >>> 8));
        __dos.writeByte((byte)__v);
    }

    static final void __writeLong40(DataOutputStream __dos, long __v) throws IOException {
        if (__v < 0L) {
            __v = 0L;
        } else if (__v > 0xFFFFFFFFFFL) {
            __v = 0xFFFFFFFFFFL;
        }
        __dos.writeByte((byte)(__v >>> 32));
        __dos.writeByte((byte)(__v >>> 24));
        __dos.writeByte((byte)(__v >>> 16));
        __dos.writeByte((byte)(__v >>> 8));
        __dos.writeByte((byte)__v);
    }

    private static final class __Position__ {
        int _narrow;
        int _wide;

        __Position__() {
        }

        __Position__(int __n, int __w) {
            this._narrow = __n;
            this._wide = __w;
        }

        public __Position__ increment(int __num) throws IllegalArgumentException {
            if (__num < 0) {
                throw new IllegalArgumentException("AH08");
            }
            int narrow = this._narrow;
            int wide = this._wide;
            __Position__ rv = new __Position__(narrow, wide);
            this._narrow = narrow + 28 + __num * 3;
            this._wide = wide + 28 + __num * 4;
            return rv;
        }
    }
}

