/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.terminal;

import cc.squirreljme.emulator.MLECallWouldFail;
import cc.squirreljme.emulator.terminal.BufferTerminalPipe;
import cc.squirreljme.emulator.terminal.DiscardTerminalPipe;
import cc.squirreljme.emulator.terminal.RealTerminalPipe;
import cc.squirreljme.emulator.terminal.TerminalPipe;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public final class TerminalPipeManager {
    private final TerminalPipe[] _pipes = new TerminalPipe[3];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() throws IOException {
        Throwable defer = null;
        TerminalPipeManager terminalPipeManager = this;
        synchronized (terminalPipeManager) {
            for (TerminalPipe pipe : this._pipes) {
                try {
                    if (pipe == null) continue;
                    pipe.close();
                }
                catch (IOException e2) {
                    if (defer == null) {
                        defer = new IOException("Pipe close exception.");
                    }
                    defer.addSuppressed(e2);
                }
            }
        }
        if (defer != null) {
            throw defer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TerminalPipe get(int __fd) throws NoSuchElementException {
        if (__fd < 0 || __fd >= 3) {
            throw new NoSuchElementException("Out of range FD: " + __fd);
        }
        TerminalPipeManager terminalPipeManager = this;
        synchronized (terminalPipeManager) {
            TerminalPipe rv = this._pipes[__fd];
            if (rv == null) {
                throw new NoSuchElementException("No such pipe at: " + __fd);
            }
            return rv;
        }
    }

    public final TerminalPipe mleGet(int __fd) throws MLECallWouldFail {
        try {
            return this.get(__fd);
        }
        catch (NoSuchElementException e2) {
            throw new MLECallWouldFail("Not a valid FD: " + __fd, e2);
        }
    }

    public final int mleRead(int __fd, byte[] __b, int __o, int __l) throws MLECallWouldFail {
        try {
            int rv = this.mleGet(__fd).read(__b, __o, __l);
            if (rv < 0) {
                return -1;
            }
            return rv;
        }
        catch (IOException e2) {
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(int __fd, TerminalPipe __pipe) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        if (__pipe == null) {
            throw new NullPointerException("NARG");
        }
        if (__fd != 1 && __fd != 2) {
            throw new IllegalArgumentException("Invalid FD: " + __fd);
        }
        TerminalPipe[] pipes = this._pipes;
        TerminalPipeManager terminalPipeManager = this;
        synchronized (terminalPipeManager) {
            if (pipes[__fd] != null) {
                throw new IllegalStateException("Already claimed FD: " + __fd);
            }
            pipes[__fd] = __pipe;
        }
    }

    public final void registerBuffer(int __fd) throws IllegalArgumentException, IllegalStateException {
        this.register(__fd, new BufferTerminalPipe());
    }

    public final void registerByType(int __fd, int __type) throws IllegalArgumentException {
        switch (__type) {
            case 0: {
                this.registerDiscard(__fd);
                break;
            }
            case 1: {
                this.registerBuffer(__fd);
                break;
            }
            case 2: {
                boolean isStdErr;
                boolean isStdOut = __fd == 1;
                boolean bl2 = isStdErr = __fd == 2;
                if (!isStdOut && !isStdErr) {
                    throw new IllegalArgumentException("Is neither stdOut or stdErr.");
                }
                this.registerTerminal(__fd, isStdOut ? System.out : System.err);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + __type);
            }
        }
    }

    public final void registerDiscard(int __fd) throws IllegalArgumentException, IllegalStateException {
        this.register(__fd, new DiscardTerminalPipe());
    }

    public final void registerTerminal(int __fd, OutputStream __out) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.register(__fd, new RealTerminalPipe(__out));
    }
}

