/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.vm;

import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.runtime.cldc.util.UnmodifiableIterator;
import cc.squirreljme.vm.VMClassLibrary;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public final class ArraySuiteManager
implements Iterable<VMClassLibrary>,
VMSuiteManager {
    private final VMClassLibrary[] _libraries;

    public ArraySuiteManager(VMClassLibrary ... __libs) {
        for (VMClassLibrary lib : this._libraries = __libs == null ? new VMClassLibrary[]{} : (VMClassLibrary[])__libs.clone()) {
            if (lib != null) continue;
            throw new NullPointerException("NARG");
        }
    }

    public ArraySuiteManager(Iterable<VMClassLibrary> __libs) {
        LinkedList<VMClassLibrary> copy = new LinkedList<VMClassLibrary>();
        for (VMClassLibrary lib : __libs) {
            copy.add(lib);
        }
        for (VMClassLibrary lib : this._libraries = copy.toArray(new VMClassLibrary[copy.size()])) {
            if (lib != null) continue;
            throw new NullPointerException("NARG");
        }
    }

    @Override
    public Iterator<VMClassLibrary> iterator() {
        return UnmodifiableIterator.of(Arrays.asList(this._libraries).iterator());
    }

    @Override
    public int libraryId(VMClassLibrary __lib) throws IllegalArgumentException, NullPointerException {
        if (__lib == null) {
            throw new NullPointerException("NARG");
        }
        VMClassLibrary[] libraries = this._libraries;
        int n2 = libraries.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (libraries[i2] != __lib) continue;
            return 1 + i2;
        }
        throw new IllegalArgumentException("Unknown library: " + __lib);
    }

    @Override
    public String[] listLibraryNames() {
        VMClassLibrary[] libraries = this._libraries;
        int n2 = libraries.length;
        String[] rv = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            rv[i2] = libraries[i2].name();
        }
        return rv;
    }

    @Override
    public VMClassLibrary loadLibrary(String __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        for (VMClassLibrary lib : this._libraries) {
            Path path = lib.path();
            if (!__s.equals(lib.name()) && (path == null || !__s.equals(path.toString()))) continue;
            return lib;
        }
        return null;
    }
}

