/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.vm;

import cc.squirreljme.emulator.vm.VMSuiteManager;
import cc.squirreljme.vm.ResourceBasedClassLibrary;
import cc.squirreljme.vm.VMClassLibrary;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ResourceBasedSuiteManager
implements VMSuiteManager {
    public final Class<?> actingclass;
    protected final String prefix;
    private final Map<String, VMClassLibrary> _cache = new HashMap<String, VMClassLibrary>();
    private String[] _libs;

    public ResourceBasedSuiteManager(Class<?> __act, String __prefix) throws NullPointerException {
        if (__act == null || __prefix == null) {
            throw new NullPointerException("NARG");
        }
        this.actingclass = __act;
        this.prefix = __prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int libraryId(VMClassLibrary __lib) throws IllegalArgumentException, NullPointerException {
        Map<String, VMClassLibrary> cache;
        if (__lib == null) {
            throw new NullPointerException("NARG");
        }
        Map<String, VMClassLibrary> map = cache = this._cache;
        synchronized (map) {
            if (!cache.values().contains(__lib)) {
                throw new IllegalArgumentException("Unknown library: " + __lib);
            }
            Path path = __lib.path();
            int n2 = path != null ? path.hashCode() : __lib.name().hashCode();
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final String[] listLibraryNames() {
        String[] libs = this._libs;
        if (libs != null) {
            return (String[])libs.clone();
        }
        try (InputStream in = this.actingclass.getResourceAsStream(this.prefix + "suites.list");){
            if (in == null) {
                libs = new String[]{};
                this._libs = libs;
                String[] stringArray = libs;
                return stringArray;
            }
            ArrayList<String> rv = new ArrayList<String>();
            try (DataInputStream dis = new DataInputStream(in);){
                int n2 = dis.readInt();
                for (int i2 = 0; i2 < n2; ++i2) {
                    rv.add(dis.readUTF());
                }
            }
            libs = rv.toArray(new String[rv.size()]);
            this._libs = libs;
            String[] stringArray = libs;
            return stringArray;
        }
        catch (IOException e2) {
            throw new RuntimeException("AK01", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final VMClassLibrary loadLibrary(String __s) throws NullPointerException {
        Map<String, VMClassLibrary> cache;
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        Map<String, VMClassLibrary> map = cache = this._cache;
        synchronized (map) {
            VMClassLibrary rv = cache.get(__s);
            if (rv != null) {
                return rv;
            }
            if (cache.containsKey(__s)) {
                return null;
            }
            boolean found = false;
            for (String q2 : this.listLibraryNames()) {
                if (found |= q2.equals(__s)) break;
            }
            if (!found) {
                cache.put(__s, null);
                return null;
            }
            rv = new ResourceBasedClassLibrary(this.actingclass, this.prefix + __s + '/', __s);
            cache.put(__s, rv);
            return rv;
        }
    }
}

