/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.emulator.vm;

import cc.squirreljme.emulator.vm.VMTraceFlag;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class VMTraceFlagTracker {
    public static final String TRACING_ENABLED = "cc.squirreljme.vm.trace";
    public static final int GLOBAL_TRACING_BITS;
    private final Map<Integer, __Level__> _levels = new LinkedHashMap<Integer, __Level__>();
    private int _nextCode;

    public VMTraceFlagTracker() {
    }

    public VMTraceFlagTracker(VMTraceFlagTracker __from) throws NullPointerException {
        if (__from == null) {
            throw new NullPointerException("NARG");
        }
        this._nextCode = __from._nextCode;
        Map<Integer, __Level__> src = __from._levels;
        Map<Integer, __Level__> dst = this._levels;
        for (Map.Entry<Integer, __Level__> e2 : src.entrySet()) {
            dst.put(e2.getKey(), new __Level__(e2.getValue()));
        }
    }

    public int activeFlags() {
        int rv = 0;
        for (Integer i2 : this._levels.keySet()) {
            if (i2 == null) continue;
            rv |= i2.intValue();
        }
        return rv;
    }

    public final int add(int __numFrames, int __flags) {
        if (__flags == 0) {
            return 0;
        }
        int code = ++this._nextCode;
        this._levels.put(code, new __Level__(__numFrames, __flags));
        return code;
    }

    public final boolean check(int __numFrames, int __flags) {
        if (__flags == 0) {
            return false;
        }
        Iterator<__Level__> iterator = this._levels.values().iterator();
        while (iterator.hasNext()) {
            __Level__ level = iterator.next();
            if (__numFrames < level._numFrames) {
                iterator.remove();
                continue;
            }
            if ((level._flags & __flags) == 0) continue;
            return true;
        }
        return false;
    }

    public final void remove(int __code) {
        this._levels.remove(__code);
    }

    public static int parseBits(String __input) throws NullPointerException {
        if (__input == null) {
            throw new NullPointerException("NARG");
        }
        int enableBits = 0;
        for (String item : __input.split(Pattern.quote(","))) {
            for (VMTraceFlag flag : VMTraceFlag.values()) {
                if (!flag.names.contains(item)) continue;
                enableBits |= flag.bits;
            }
        }
        return enableBits;
    }

    static {
        String tracing = System.getProperty(TRACING_ENABLED);
        int enableBits = 0;
        if (tracing != null) {
            enableBits = VMTraceFlagTracker.parseBits(tracing);
        }
        GLOBAL_TRACING_BITS = enableBits;
    }

    private static final class __Level__ {
        final int _numFrames;
        final int _flags;

        __Level__(int __numFrames, int __flags) {
            this._numFrames = __numFrames;
            this._flags = __flags;
        }

        __Level__(__Level__ __from) throws NullPointerException {
            if (__from == null) {
                throw new NullPointerException("NARG");
            }
            this._flags = __from._flags;
            this._numFrames = __from._numFrames;
        }
    }
}

