/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp;

import cc.squirreljme.jdwp.JDWPCommLinkDirection;
import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPIdSizes;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;

public final class JDWPCommLink
implements Closeable {
    public static final boolean DEBUG = Boolean.getBoolean("cc.squirreljme.jdwp.debug");
    private static final byte[] _HANDSHAKE_SEQUENCE = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    private static final int _INIT_DATA_LEN = 1024;
    static final int _HEADER_SIZE = 11;
    protected final DataInputStream in;
    protected final DataOutputStream out;
    protected final JDWPCommLinkDirection direction;
    private final Deque<JDWPPacket> _freePackets = new LinkedList<JDWPPacket>();
    private final byte[] _header = new byte[11];
    private final Object _outMonitor = new Object();
    private volatile JDWPIdSizes _idSizes;
    private volatile int _headerAt;
    private volatile byte[] _data = new byte[1024];
    private volatile int _dataAt;
    private volatile int _dataLen = -1;
    private volatile boolean _didHandshake;
    volatile boolean _shutdown;
    private volatile int _nextId;

    public JDWPCommLink(InputStream __in, OutputStream __out) throws NullPointerException {
        this(__in, __out, JDWPCommLinkDirection.CLIENT_TO_DEBUGGER);
    }

    public JDWPCommLink(InputStream __in, OutputStream __out, JDWPCommLinkDirection __direction) throws NullPointerException {
        if (__in == null || __out == null || __direction == null) {
            throw new NullPointerException("NARG");
        }
        this.in = new DataInputStream(__in);
        this.out = new DataOutputStream(__out);
        this.direction = __direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areSizesKnown() {
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            return this._idSizes != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JDWPException {
        IOException fail = null;
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            this._shutdown = true;
        }
        try {
            this.in.close();
        }
        catch (IOException e2) {
            fail = e2;
        }
        try {
            this.out.close();
        }
        catch (IOException e3) {
            if (fail == null) {
                fail = e3;
            }
            fail.addSuppressed(e3);
        }
        if (fail != null) {
            throw new JDWPException("AG09", fail);
        }
    }

    public JDWPPacket getPacket() {
        return this.__getPacket(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPIdSizes idSizes() {
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            return this._idSizes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            return this._shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int nextId() {
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            return ++this._nextId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPPacket poll() throws JDWPException {
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            if (!this._didHandshake) {
                this.__handshake();
            }
        }
        byte[] header = this._header;
        int headerAt = this._headerAt;
        byte[] data = this._data;
        int dataLen = this._dataLen;
        int dataAt = this._dataAt;
        DataInputStream in = this.in;
        while (true) {
            try {
                if (this._shutdown) {
                    JDWPPacket jDWPPacket = null;
                    return jDWPPacket;
                }
                int headerLeft = 11 - headerAt;
                if (headerLeft > 0) {
                    int rc = ((InputStream)in).read(header, headerAt, headerLeft);
                    if (rc < 0) {
                        if (headerAt > 0) {
                            throw new EOFException("AG07");
                        }
                        this._shutdown = true;
                        JDWPPacket jDWPPacket = null;
                        return jDWPPacket;
                    }
                    headerLeft -= rc;
                    headerAt += rc;
                }
                if (headerLeft > 0) continue;
                if (dataLen < 0 && (dataLen = Math.max(((header[0] & 0xFF) << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF) - 11, 0)) > data.length) {
                    data = new byte[dataLen];
                }
                int dataLeft = dataLen - dataAt;
                if (dataLen >= 0 && dataLeft > 0) {
                    int rc = ((InputStream)in).read(data, dataAt, dataLeft);
                    if (rc < 0) {
                        if (dataAt > 0) {
                            throw new EOFException("AG08");
                        }
                        this._shutdown = true;
                        JDWPPacket jDWPPacket = null;
                        return jDWPPacket;
                    }
                    dataLeft -= rc;
                    dataAt += rc;
                }
                if (dataLen >= 0 && dataLeft > 0) continue;
                JDWPPacket packet = this.__getPacket(false);
                packet.__load(header, data, dataLen);
                headerAt = 0;
                dataAt = 0;
                dataLen = -1;
                JDWPPacket jDWPPacket = packet;
                return jDWPPacket;
            }
            catch (InterruptedIOException ignored) {
                JDWPPacket jDWPPacket = null;
                return jDWPPacket;
            }
            catch (IOException e2) {
                this._shutdown = true;
                throw new JDWPException("AG06", e2);
            }
            finally {
                this._headerAt = headerAt;
                this._data = data;
                this._dataLen = dataLen;
                this._dataAt = dataAt;
                continue;
            }
            break;
        }
    }

    public JDWPPacket reply(int __id, JDWPErrorType __error) throws NullPointerException {
        if (__error == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket rv = this.__getPacket(true);
        rv._id = __id;
        rv._errorCode = __error;
        rv._rawErrorCode = __error.id;
        rv._flags = 128;
        return rv;
    }

    public JDWPPacket reply(JDWPPacket __packet, JDWPErrorType __error) throws NullPointerException {
        if (__packet == null || __error == null) {
            throw new NullPointerException("NARG");
        }
        return this.reply(__packet.id(), __error);
    }

    public JDWPPacket request(JDWPCommandSet __commandSet, JDWPCommand __command) throws NullPointerException {
        if (__commandSet == null || __command == null) {
            throw new NullPointerException("NARG");
        }
        return this.request(__commandSet.id, __command.debuggerId());
    }

    public JDWPPacket request(int __commandSet, int __command) {
        JDWPPacket rv = this.__getPacket(true);
        rv._id = this.nextId();
        rv._commandSet = __commandSet;
        rv._command = __command;
        rv._flags = 0;
        rv._errorCode = JDWPErrorType.NO_ERROR;
        rv._rawErrorCode = 0;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JDWPPacket __packet) throws JDWPException, NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        Object object = this;
        synchronized (object) {
            if (!this._didHandshake) {
                this.__handshake();
            }
        }
        if (DEBUG) {
            Debugging.debugNote("JDWP: -> %s", __packet);
        }
        try {
            object = this._outMonitor;
            synchronized (object) {
                __packet.writeTo(this.out);
                this.out.flush();
            }
        }
        catch (IOException e2) {
            throw new JDWPException("AG01 " + __packet, e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIdSizes(JDWPIdSizes __idSizes) throws NullPointerException {
        if (__idSizes == null) {
            throw new NullPointerException("NARG");
        }
        JDWPCommLink jDWPCommLink = this;
        synchronized (jDWPCommLink) {
            this._idSizes = __idSizes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDWPPacket __getPacket(boolean __open) {
        Deque<JDWPPacket> freePackets;
        Deque<JDWPPacket> deque = freePackets = this._freePackets;
        synchronized (deque) {
            JDWPPacket rv = freePackets.isEmpty() ? new JDWPPacket(freePackets) : freePackets.remove();
            rv.__resetAndOpen(__open, this._idSizes);
            return rv;
        }
    }

    private void __handshake() throws JDWPException {
        try {
            if (DEBUG) {
                Debugging.debugNote("JDWP: Handshake.");
            }
            if (this.direction == JDWPCommLinkDirection.CLIENT_TO_DEBUGGER) {
                this.__handshakeRead();
                this.__handshakeWrite();
            } else {
                this.__handshakeWrite();
                this.__handshakeRead();
            }
            this._didHandshake = true;
            if (DEBUG) {
                Debugging.debugNote("JDWP: Hands shaken at a distance.");
            }
        }
        catch (IOException e2) {
            throw new JDWPException("AG04", e2);
        }
    }

    private void __handshakeRead() throws IOException {
        int seqLen = _HANDSHAKE_SEQUENCE.length;
        byte[] debuggerShake = new byte[seqLen];
        for (int i2 = 0; i2 < seqLen; ++i2) {
            int read = this.in.read();
            if (read < 0) {
                throw new JDWPException("AG02");
            }
            debuggerShake[i2] = (byte)read;
        }
        if (!Arrays.equals(debuggerShake, _HANDSHAKE_SEQUENCE)) {
            throw new JDWPException("AG03");
        }
    }

    private void __handshakeWrite() throws IOException {
        this.out.write(_HANDSHAKE_SEQUENCE);
        this.out.flush();
    }
}

