/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSetArrayReference;
import cc.squirreljme.jdwp.JDWPCommandSetClassLoader;
import cc.squirreljme.jdwp.JDWPCommandSetClassObjectReference;
import cc.squirreljme.jdwp.JDWPCommandSetClassType;
import cc.squirreljme.jdwp.JDWPCommandSetEventRequest;
import cc.squirreljme.jdwp.JDWPCommandSetMethod;
import cc.squirreljme.jdwp.JDWPCommandSetObjectReference;
import cc.squirreljme.jdwp.JDWPCommandSetReferenceType;
import cc.squirreljme.jdwp.JDWPCommandSetStackFrame;
import cc.squirreljme.jdwp.JDWPCommandSetStringReference;
import cc.squirreljme.jdwp.JDWPCommandSetThreadGroupReference;
import cc.squirreljme.jdwp.JDWPCommandSetThreadReference;
import cc.squirreljme.jdwp.JDWPCommandSetVirtualMachine;
import cc.squirreljme.jdwp.JDWPHasId;
import cc.squirreljme.jdwp.JDWPIdMap;

public enum JDWPCommandSet implements JDWPHasId
{
    UNKNOWN(-1, new JDWPCommand[0]),
    VIRTUAL_MACHINE(1, JDWPCommandSetVirtualMachine.values()),
    REFERENCE_TYPE(2, JDWPCommandSetReferenceType.values()),
    CLASS_TYPE(3, JDWPCommandSetClassType.values()),
    METHODS(6, JDWPCommandSetMethod.values()),
    OBJECT_REFERENCE(9, JDWPCommandSetObjectReference.values()),
    STRING_REFERENCE(10, JDWPCommandSetStringReference.values()),
    THREAD_REFERENCE(11, JDWPCommandSetThreadReference.values()),
    THREAD_GROUP_REFERENCE(12, JDWPCommandSetThreadGroupReference.values()),
    ARRAY_REFERENCE(13, JDWPCommandSetArrayReference.values()),
    CLASS_LOADER(14, JDWPCommandSetClassLoader.values()),
    EVENT_REQUEST(15, JDWPCommandSetEventRequest.values()),
    STACK_FRAMES(16, JDWPCommandSetStackFrame.values()),
    CLASS_OBJECT_REFERENCE(17, JDWPCommandSetClassObjectReference.values());

    private static final JDWPIdMap<JDWPCommandSet> _QUICK;
    public final int id;
    private final JDWPIdMap<JDWPCommand> _commands;

    private JDWPCommandSet(int __id, JDWPCommand ... __cmds) {
        this.id = __id;
        this._commands = new JDWPIdMap((JDWPHasId[])__cmds);
    }

    public final JDWPCommand command(int __id) {
        return (JDWPCommand)this._commands.get(__id);
    }

    @Override
    public final int debuggerId() {
        return this.id;
    }

    public static JDWPCommandSet of(int __id) {
        JDWPCommandSet rv = (JDWPCommandSet)_QUICK.get(__id);
        if (rv == null) {
            return UNKNOWN;
        }
        return rv;
    }

    static {
        _QUICK = new JDWPIdMap((JDWPHasId[])JDWPCommandSet.values());
    }
}

