/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp;

import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.runtime.cldc.util.IntegerArrayList;

public final class JDWPIdSizes {
    private final int[] _sizes;

    public JDWPIdSizes(int ... __sizes) throws IllegalArgumentException, NullPointerException {
        if (__sizes == null) {
            throw new NullPointerException("NARG");
        }
        if (__sizes.length != 5) {
            throw new IllegalArgumentException("IOOB");
        }
        JDWPIdKind[] kinds = JDWPIdKind.values();
        int[] normalized = new int[kinds.length];
        System.arraycopy(__sizes, 0, normalized, 0, 5);
        for (JDWPIdKind kind : kinds) {
            if (kind.position >= 0) continue;
            normalized[kind.ordinal()] = normalized[JDWPIdKind.invert(kind.position)];
        }
        this._sizes = normalized;
    }

    public int getSize(JDWPIdKind __idSize) throws NullPointerException {
        if (__idSize == null) {
            throw new NullPointerException("NARG");
        }
        return this._sizes[__idSize.ordinal()];
    }

    public int getSize(int __idSize) throws IndexOutOfBoundsException {
        if (__idSize < 0 || __idSize >= 5) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        return this._sizes[__idSize];
    }

    public String toString() {
        return new IntegerArrayList(this._sizes).toString();
    }
}

