/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.jdwp;

import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.jdwp.JDWPIdSizeUnknownException;
import cc.squirreljme.jdwp.JDWPIdSizes;
import cc.squirreljme.jdwp.JDWPValue;
import cc.squirreljme.jdwp.JDWPValueTag;
import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.debug.ErrorCode;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Deque;

public final class JDWPPacket
implements Closeable {
    public static final short FLAG_REPLY = 128;
    private static final byte _GROW_SIZE = 32;
    private final Reference<Deque<JDWPPacket>> _queue;
    volatile int _id;
    volatile int _flags;
    volatile int _commandSet = -1;
    volatile int _command = -1;
    volatile int _rawErrorCode;
    volatile JDWPErrorType _errorCode;
    private volatile byte[] _data;
    private volatile JDWPIdSizes _idSizes;
    private volatile int _length;
    private volatile int _readPos;
    private volatile boolean _open;

    JDWPPacket(Deque<JDWPPacket> __queue) throws NullPointerException {
        if (__queue == null) {
            throw new NullPointerException("NARG");
        }
        this._queue = new WeakReference<Deque<JDWPPacket>>(__queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            if (!this._open) {
                return;
            }
            this._open = false;
            Deque<JDWPPacket> queue = this._queue.get();
            if (queue != null) {
                Deque<JDWPPacket> deque = queue;
                synchronized (deque) {
                    queue.add(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int command() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.__checkType(false);
            return this._command;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPCommandSet commandSet() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.__checkType(false);
            return JDWPCommandSet.of(this._commandSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commandSetId() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.__checkType(false);
            return this._commandSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPPacket copyOf(JDWPPacket __packet) throws NullPointerException {
        byte[] data;
        JDWPIdSizes idSizes;
        int readPos;
        int length;
        JDWPErrorType errorCode;
        int command;
        int commandSet;
        int flags;
        int id;
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = __packet;
        synchronized (jDWPPacket) {
            id = __packet._id;
            flags = __packet._flags;
            commandSet = __packet._commandSet;
            command = __packet._command;
            errorCode = __packet._errorCode;
            length = __packet._length;
            readPos = __packet._readPos;
            idSizes = __packet._idSizes;
            data = __packet._data != null ? (byte[])__packet._data.clone() : null;
        }
        jDWPPacket = this;
        synchronized (jDWPPacket) {
            this._id = id;
            this._flags = flags;
            this._commandSet = commandSet;
            this._command = command;
            this._errorCode = errorCode;
            this._length = length;
            this._readPos = readPos;
            this._idSizes = idSizes;
            if (data != null) {
                byte[] ourData = this._data;
                if (ourData != null && ourData.length >= data.length) {
                    ObjectShelf.arrayCopy(data, 0, ourData, 0, data.length);
                } else {
                    this._data = data;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPErrorType error() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return this._errorCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasError() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return this._errorCode != JDWPErrorType.NO_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasError(JDWPErrorType __error) throws NullPointerException {
        if (__error == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return this._errorCode == __error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int id() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return this._id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPIdSizes idSizes() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return this._idSizes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReply() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return (this._flags & 0x80) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return this._length;
        }
    }

    public boolean readBoolean() throws JDWPException {
        return this.readByte() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte readByte() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            int readPos = this._readPos;
            if (readPos >= this._length) {
                throw new JDWPException(ErrorCode.__error__("AG0d", readPos, this._length));
            }
            byte rv = this._data[readPos];
            this._readPos = readPos + 1;
            return rv;
        }
    }

    public byte[] readFully(int __length) throws IllegalArgumentException, JDWPException {
        if (__length < 0) {
            throw new IllegalArgumentException("NEGV");
        }
        return this.readFully(new byte[__length], 0, __length);
    }

    public byte[] readFully(byte[] __buf) throws JDWPException, NullPointerException {
        if (__buf == null) {
            throw new NullPointerException("NARG");
        }
        return this.readFully(__buf, 0, __buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFully(byte[] __buf, int __off, int __len) throws IndexOutOfBoundsException, JDWPException, NullPointerException {
        if (__buf == null) {
            throw new NullPointerException("NARG");
        }
        int bufLen = __buf.length;
        if (__off < 0 || __len < 0 || __off + __len > bufLen || __off + __len < 0) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            int i2 = 0;
            int at2 = __off;
            while (i2 < __len) {
                __buf[at2] = this.readByte();
                ++i2;
                ++at2;
            }
        }
        return __buf;
    }

    @Deprecated
    public final int readId() throws JDWPException {
        return this.readId(JDWPIdKind.UNKNOWN).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPId readId(JDWPIdKind __kind) throws JDWPException, NullPointerException {
        if (__kind == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return JDWPId.of(__kind, this.readVariable(this.__sizeOf(__kind)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readInt() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return ((long)this.readByte() & 0xFFL) << 56 | ((long)this.readByte() & 0xFFL) << 48 | ((long)this.readByte() & 0xFFL) << 40 | ((long)this.readByte() & 0xFFL) << 32 | ((long)this.readByte() & 0xFFL) << 24 | (long)((this.readByte() & 0xFF) << 16) | (long)((this.readByte() & 0xFF) << 8) | (long)(this.readByte() & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
        }
    }

    public final String readString() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            int len = this.readInt();
            byte[] utf = new byte[len];
            for (int i2 = 0; i2 < len; ++i2) {
                utf[i2] = this.readByte();
            }
            try {
                return new String(utf, "utf-8");
            }
            catch (UnsupportedEncodingException __e) {
                throw new JDWPException("AG0f", __e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPId readTaggedObjectId() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            JDWPIdKind kind;
            this.__checkOpen();
            JDWPValueTag tag = JDWPValueTag.fromTag(this.readByte());
            if (tag == null) {
                tag = JDWPValueTag.OBJECT;
            }
            switch (tag) {
                case THREAD: {
                    kind = JDWPIdKind.THREAD_ID;
                    break;
                }
                case CLASS_OBJECT: {
                    kind = JDWPIdKind.REFERENCE_TYPE_ID;
                    break;
                }
                default: {
                    kind = JDWPIdKind.OBJECT_ID;
                }
            }
            return this.readId(kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDWPValue readValue() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            Comparable<JDWPId> value;
            this.__checkOpen();
            byte rawTag = this.readByte();
            JDWPValueTag tag = JDWPValueTag.fromTag(rawTag);
            if (tag == null) {
                throw new JDWPException("ITAG " + rawTag);
            }
            switch (tag) {
                case VOID: {
                    value = null;
                    break;
                }
                case CLASS_OBJECT: 
                case ARRAY: 
                case OBJECT: 
                case STRING: 
                case CLASS_LOADER: 
                case THREAD_GROUP: {
                    value = this.readId(JDWPIdKind.OBJECT_ID);
                    break;
                }
                case THREAD: {
                    value = this.readId(JDWPIdKind.THREAD_ID);
                    break;
                }
                case BOOLEAN: {
                    value = this.readByte() != 0;
                    break;
                }
                case BYTE: {
                    value = this.readByte();
                    break;
                }
                case SHORT: {
                    value = this.readShort();
                    break;
                }
                case CHARACTER: {
                    value = Character.valueOf((char)this.readShort());
                    break;
                }
                case INTEGER: {
                    value = this.readInt();
                    break;
                }
                case LONG: {
                    value = this.readLong();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.intBitsToFloat(this.readInt()));
                    break;
                }
                case DOUBLE: {
                    value = Double.longBitsToDouble(this.readLong());
                    break;
                }
                default: {
                    throw new JDWPException("ITAG " + rawTag);
                }
            }
            return new JDWPValue(tag, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long readVariable(int __width) throws IllegalArgumentException, JDWPException {
        if (__width <= 0) {
            throw new IllegalArgumentException("NEGV");
        }
        long result = 0L;
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            for (int i2 = 0; i2 < __width; ++i2) {
                result <<= 8;
                result |= (long)(this.readByte() & 0xFF);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JDWPPacket resetReadPosition() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this._readPos = 0;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdSizes(JDWPIdSizes __sizes) throws NullPointerException {
        if (__sizes == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this._idSizes = __sizes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            byte[] data = this._data;
            if (data == null) {
                return new byte[0];
            }
            int len = this._length;
            byte[] result = new byte[len];
            ObjectShelf.arrayCopy(data, 0, result, 0, len);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            if (!this._open) {
                return "JDWPPacket:Closed";
            }
            JDWPCommandSet commandSet = JDWPCommandSet.of(this._commandSet);
            JDWPCommand command = commandSet == null ? null : commandSet.command(this._command);
            int length = this._length;
            byte[] data = this._data;
            StringBuilder sb = new StringBuilder(length * 2);
            for (int i2 = 0; i2 < length; ++i2) {
                byte b2 = data[i2];
                sb.append(Character.forDigit((b2 & 0xF0) >>> 4 & 0xF, 16));
                sb.append(Character.forDigit(b2 & 0xF, 16));
            }
            int flags = this._flags;
            Object[] objectArray = new Object[5];
            objectArray[0] = this._id;
            objectArray[1] = flags;
            objectArray[2] = length;
            objectArray[3] = (flags & 0x80) != 0 ? (this._errorCode == JDWPErrorType.NO_ERROR ? "" : String.format("[error=%s(%d)]", this._errorCode, this._rawErrorCode)) : String.format("[cmdSet=%s;cmd=%s]", commandSet == null || commandSet == JDWPCommandSet.UNKNOWN ? Integer.valueOf(this._commandSet) : commandSet, command == null ? Integer.valueOf(this._command) : command);
            objectArray[4] = sb;
            return String.format("JDWPPacket[id=%08x,flags=%02x,len=%d]:%s:%s", objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, JDWPException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            for (int i2 = 0; i2 < __l; ++i2) {
                this.writeByte(__b[__o + i2]);
            }
        }
    }

    public void writeBoolean(boolean __b) throws JDWPException {
        this.writeByte(__b ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(int __v) {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            int length = this._length;
            byte[] data = this._data;
            if (data == null || length + 1 > data.length) {
                data = data == null ? new byte[32] : Arrays.copyOf(data, data.length + 32);
                this._data = data;
            }
            data[length] = (byte)__v;
            this._length = length + 1;
        }
    }

    @Deprecated
    public void writeId(int __v) throws JDWPException {
        this.writeId(JDWPId.of(JDWPIdKind.UNKNOWN, __v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeId(JDWPId __id) throws NullPointerException, JDWPException {
        if (__id == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.writeVariable(this.__sizeOf(__id.kind), __id.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(int __v) throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.writeByte(__v >> 24);
            this.writeByte(__v >> 16);
            this.writeByte(__v >> 8);
            this.writeByte(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long __v) throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.writeByte((byte)(__v >> 56));
            this.writeByte((byte)(__v >> 48));
            this.writeByte((byte)(__v >> 40));
            this.writeByte((byte)(__v >> 32));
            this.writeByte((byte)(__v >> 24));
            this.writeByte((byte)(__v >> 16));
            this.writeByte((byte)(__v >> 8));
            this.writeByte((byte)__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(int __v) throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.writeByte(__v >> 8);
            this.writeByte(__v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeString(String __string) throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            byte[] bytes;
            try {
                bytes = __string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException __e) {
                throw new JDWPException("AG0e", __e);
            }
            this.writeInt(bytes.length);
            for (byte b2 : bytes) {
                this.writeByte(b2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DataOutputStream __out) throws IOException, NullPointerException {
        if (__out == null) {
            throw new NullPointerException("NARG");
        }
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            __out.writeInt(this._length + 11);
            __out.writeInt(this._id);
            __out.writeByte(this._flags);
            if (this.isReply()) {
                __out.writeShort(this._errorCode.id);
            } else {
                __out.writeByte(this._commandSet);
                __out.writeByte(this._command);
            }
            if (this._length > 0) {
                __out.write(this._data, 0, this._length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeVariable(int __width, long __v) throws IllegalArgumentException, JDWPException {
        if (__width <= 0) {
            throw new IllegalArgumentException("NEGV");
        }
        __v = Long.reverseBytes(__v) >>> 64 - __width * 8;
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            for (int i2 = 0; i2 < __width; ++i2) {
                this.writeByte((byte)__v);
                __v >>>= 8;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeVoid() throws JDWPException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            this.__checkOpen();
            this.writeByte(86);
        }
    }

    void __checkOpen() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("AG0b");
        }
    }

    void __checkType(boolean __isReply) throws IllegalStateException {
        if (__isReply != this.isReply()) {
            throw new IllegalStateException("AG0c " + __isReply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __load(byte[] __header, byte[] __data, int __dataLen) throws NullPointerException {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            if (this._open) {
                throw new IllegalStateException("AG0a");
            }
            byte[] data = this._data;
            if (data == null || data.length < __dataLen) {
                this._data = data = new byte[__dataLen];
            }
            ObjectShelf.arrayCopy(__data, 0, data, 0, __dataLen);
            this._length = __dataLen;
            this._id = (__header[4] & 0xFF) << 24 | (__header[5] & 0xFF) << 16 | (__header[6] & 0xFF) << 8 | __header[7] & 0xFF;
            byte flags = __header[8];
            this._flags = flags & 0xFF;
            if ((flags & 0x80) != 0) {
                int rawErrorCode;
                this._commandSet = -1;
                this._command = -1;
                this._rawErrorCode = rawErrorCode = (__header[9] & 0xFF) << 8 | __header[10] & 0xFF;
                this._errorCode = JDWPErrorType.of(rawErrorCode);
            } else {
                this._rawErrorCode = 0;
                this._errorCode = null;
                this._commandSet = __header[9] & 0xFF;
                this._command = __header[10] & 0xFF;
            }
            this._open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __resetAndOpen(boolean __open, JDWPIdSizes __idSizes) {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            if (this._open) {
                throw new JDWPException("AG05");
            }
            this._id = 0;
            this._flags = 0;
            this._commandSet = -1;
            this._command = -1;
            this._errorCode = null;
            this._rawErrorCode = -1;
            this._length = 0;
            this._readPos = 0;
            this._idSizes = __idSizes;
            this._open = __open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int __sizeOf(JDWPIdKind __kind) {
        JDWPPacket jDWPPacket = this;
        synchronized (jDWPPacket) {
            JDWPIdSizes idSizes = this._idSizes;
            if (idSizes == null) {
                throw new JDWPIdSizeUnknownException("AG0z");
            }
            return idSizes.getSize(__kind);
        }
    }
}

